#!/usr/bin/perl

package LCM::App::HdbLcmConsoleInstalled;

use strict;
use LCM::Configuration::HdbLcmInstalledActionConfiguration;
use LCM::Configuration::GenericStackUninstallation;
use LCM::Configuration::UpdateComponentListConfiguration;
use LCM::Configuration::PrintComponentListConfiguration;
use LCM::Configuration::PrintDetectedComponentsConfiguration;
use LCM::Configuration::SLD::RegistrationConfiguration;
use LCM::Configuration::InternalNetworkConfiguration;
use LCM::Configuration::UpdateSystemBootstrapConfiguration;
use LCM::Task::ConfigureInternalNetworkProcessTask;
use LCM::Configuration::RenameSystemConfiguration;
use LCM::Task::RenameSystemProcessTask;
use LCM::Configuration::Hosts::HostsConfigurationFactory;
use LCM::Task::AddHostsProcessTask;
use LCM::Task::RemoveHostsProcessTask;
use SDB::Install::SysVars qw($isWin);
use SDB::Install::App::Console::LCMUnregister;
use LCM::Configuration::UnregisterConfiguration;
use LCM::Configuration::ExtractComponentsConfiguration;
use LCM::Configuration::AddHostRolesConfiguration;
use LCM::Configuration::CheckInstallationConfiguration;
use LCM::Configuration::RemoveHostRolesConfiguration;
use SDB::Install::App::Console::Rename;
use LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration;
use LCM::Task::UpdateComponentListProcessTask;
use LCM::Task::UninstallationProcessTask;
use LCM::Executors::ExecutionWarningsHandler;
use LCM::ExecutionWarningsObservable;
use LCM::Task::GenericStackTask::UpdateProcessTask;
use base qw (LCM::App::BaseApplication);
use LCM::ComponentProgressHandler;
use LCM::Task::ConfigureSLDProcessTask;
use LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask;
use LCM::Task::AddHostRolesProcessTask;
use LCM::Task::UpdateHostProcessTask;
use LCM::Task::CheckInstallationTask::CheckInstallationProcessTask;
use LCM::Task::RemoveHostRolesProcessTask;
use LCM::Task::UpdateSystemBootstrapProcessTask;
use LCM::Task::PrintComponentListProcessTask;
use LCM::Task::PrintDetectedComponentsProcessTask;
use LCM::Task::HelpProcessTask;
use LCM::Task::DumpConfigfileTemplateProcessTask;
use LCM::TaskHandler::UpdateSystemBootstrapTaskHandler;
use LCM::ComponentManager::PrintDetectedComponentsOutputHandler;
use LCM::TaskHandler;

sub createExecutor {
	my ( $self, $action ) = @_;
    my $componentProgressHandler = new LCM::ComponentProgressHandler ();

    my $executor = undef;
    if ($self->isHelp()) {
        return new LCM::Task::HelpProcessTask($self->getInstconfig(), $self);
    } elsif ($self->isDumpTemplate()) {
        return new LCM::Task::DumpConfigfileTemplateProcessTask($self->getInstconfig(), $self);
    } elsif ( 'uninstall' eq $action ) {
		$executor = new LCM::Task::UninstallationProcessTask($self->getInstconfig());
		$executor->addListener($componentProgressHandler);
		return $executor;
	} elsif ( "update_component_list" eq $action ) {
		$executor = new LCM::Task::UpdateComponentListProcessTask( $self->{instconfig} );
        $executor->addListener($componentProgressHandler);
	} elsif ('print_component_list' eq $action){
		$executor = new LCM::Task::PrintComponentListProcessTask( $self->{instconfig} );
	} elsif ('configure_sld' eq $action) {
		$executor = new LCM::Task::ConfigureSLDProcessTask($self->{instconfig});
		return $executor;
	} elsif ('update' eq $action) {
        $executor = new LCM::Task::UpdateSystemBootstrapProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    } elsif ('update_components' eq $action) {
		$executor = new LCM::Task::GenericStackTask::UpdateProcessTask( $self->getInstconfig());
		$executor->addListener($componentProgressHandler);
		return $executor;
	} elsif ('configure_internal_network' eq $action) {
		$executor = new LCM::Task::ConfigureInternalNetworkProcessTask($self->{instconfig});
		$executor->addListener($componentProgressHandler);
		return $executor;
	} elsif ( !$isWin && (('rename_system' eq $action) || ('register_rename_system' eq $action) || ('continue_rename' eq $action)) ) {
	    # currently rename scenario is supported only under linux
        $executor = new LCM::Task::RenameSystemProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    } elsif ('add_hosts' eq $action) {
		$executor = new LCM::Task::AddHostsProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    } elsif ('remove_hosts' eq $action) {
		$executor = new LCM::Task::RemoveHostsProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
	} elsif ('update_host' eq $action) {
        $executor = new LCM::Task::UpdateHostProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    } elsif ( !$isWin && ($action =~ m/^unregister_(system|instance)$/)) {
        require LCM::Task::UnregisterProcessTask;
        $executor = new LCM::Task::UnregisterProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
        return $executor;
	} elsif (!$isWin && 'extract_components' eq $action) {
        $executor = new LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
        return $executor;
    }elsif (!$isWin && 'add_host_roles' eq $action){
        $executor = new LCM::Task::AddHostRolesProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    }elsif (!$isWin && 'check_installation' eq $action){
        $executor = new LCM::Task::CheckInstallationTask::CheckInstallationProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    }elsif (!$isWin && 'remove_host_roles' eq $action) {
        $executor = new LCM::Task::RemoveHostRolesProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    } elsif ('print_detected_components' eq $action){
        $executor = new LCM::Task::PrintDetectedComponentsProcessTask($self->{instconfig});
        $executor->addListener($componentProgressHandler);
    }

	if(defined $executor){
        # TODO: FIX AFTER REFACTORING END: For configure_sld this may not be required but take in mind for further action until finish of the refactoring
        LCM::ExecutionWarningsObservable->getInstance()->registerListener(LCM::Executors::ExecutionWarningsHandler->new($executor));
	}

	return $executor;
}

sub createConfiguration {
	my ( $self, $action ) = @_;

	if ( 'uninstall' eq $action ) {
		return new LCM::Configuration::GenericStackUninstallation( $self->{options}, $self->{configfile} );
	} elsif ( "update_component_list" eq $action ) {
		return new LCM::Configuration::UpdateComponentListConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( "print_component_list" eq $action ) {
		return new LCM::Configuration::PrintComponentListConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( 'configure_sld' eq $action ) {
		return new LCM::Configuration::SLD::RegistrationConfiguration($self->{options}, $self->{configfile});
	} elsif ('update_components' eq $action) {
		require  LCM::Configuration::GenericStackConfigurationFactory;
		my $config =  LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateResidentConfiguration($self);
        my $componentManager = $config->getComponentManager();
        $componentManager->setPrintAllDetectedComponents(1);
        $componentManager->addComponentsOutputHandler(LCM::ComponentManager::PrintDetectedComponentsOutputHandler->new());
        return $config;
	} elsif ('update' eq $action) {
        return new LCM::Configuration::UpdateSystemBootstrapConfiguration($self->{options}, $self->{configfile});
    } elsif ('configure_internal_network' eq $action) {
		return new LCM::Configuration::InternalNetworkConfiguration($self->{options}, $self->{configfile});
	} elsif ( !$isWin && (('rename_system' eq $action) || ('register_rename_system' eq $action) || ('continue_rename' eq $action)) ) {
	   	# currently rename scenario is supported only under linux
       	return new LCM::Configuration::RenameSystemConfiguration( $self->{options}, $self->{configfile});
    } elsif ('add_hosts' eq $action) {
		return LCM::Configuration::Hosts::HostsConfigurationFactory::NewAddHostsConfiguration( $self->{actionInstconfig}, $self->{options}, $self->{configfile} );
	} elsif ('remove_hosts' eq $action) {
		return new LCM::Configuration::Hosts::RemoveHosts::RemoveHostsConfiguration( $self->{options}, $self->{configfile} );
	} elsif ( !$isWin && ($action =~ m/^unregister_(system|instance)$/)) {
        # currently register scenario is supported only under linux
        return new LCM::Configuration::UnregisterConfiguration($action, $self->{options}, $self->{configfile});
	} elsif ('update_host' eq $action) {
		require    LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration;
        return new LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration( $self->{options}, $self->{configfile} );
    }  elsif ( !$isWin && 'extract_components' eq $action) {
        return new LCM::Configuration::ExtractComponentsConfiguration($self->{options}, $self->{configfile});
    }  elsif ( !$isWin && 'add_host_roles' eq $action) {
        return new LCM::Configuration::AddHostRolesConfiguration($self->{options}, $self->{configfile});
    } elsif ( !$isWin && 'check_installation' eq $action) {
        return new LCM::Configuration::CheckInstallationConfiguration($self->{options}, $self->{configfile});
    } elsif ( !$isWin && 'remove_host_roles' eq $action) {
        return new LCM::Configuration::RemoveHostRolesConfiguration($self->{options}, $self->{configfile});
    } elsif ( "print_detected_components" eq $action ) {
        return new LCM::Configuration::PrintDetectedComponentsConfiguration($self->{options}, $self->{configfile});
    }
	return undef;
}

sub createTaskHandler {
    my ($self, $action) = @_;
    my @args = ($self->getInstconfig(), $self->getExecutor(), $self->getCLIParser(), $self->GetSysInfo(), $self->_getConsole());
    if ($action && $action eq 'update') {
        return LCM::TaskHandler::UpdateSystemBootstrapTaskHandler->new(@args);
    }
    return $self->SUPER::createTaskHandler($action);
}

sub createActionConfiguration {
	my $self = shift;
	return new LCM::Configuration::HdbLcmInstalledActionConfiguration( $self->{options}, $self->{configfile} );
}

sub CleanUp{
	my $self = shift();
	my $instconfig = $self->{'instconfig'};
    if(!$isWin && defined $instconfig && $instconfig->isa('LCM::Configuration::GenericStackUninstallation')) {
        my $systemComponentManager = $instconfig->getSystemComponentManager();
        if(defined $systemComponentManager && $systemComponentManager->isHDBServerComponentSelected()) {
            my $rootDir = $instconfig->{'sapSys'}->get_globalSidDir();
            if(defined $rootDir) {
                $self->{'rootDirToBeDeletedOnExitOfMain'} = $rootDir;
            }
        }
    }
	$self->SUPER::CleanUp();
}

sub isResident {
    return 1;
}

sub getFlavour {
    my $self = shift;
    my $installer = new LCM::Installer();
    my $installation = $installer->getInstallation();
    return $installation->getHANAFlavour();
}

1;
