package LCM::Component::Installable::HDBClient::HDBClientRoot;

use SDB::Install::SysVars qw($isWin $path_separator);
use LCM::ProcessExecutor;
use LCM::Component::Installable::HDBClient::HDBClientBase;
use strict;

use base 'LCM::Component::Installable::HDBClient::HDBClientBase';

sub updateComponent {
    my ($self) = shift;
    return $self->installComponent(@_);
}

sub installComponent {
    my ( $self, $instconfig ) = @_;

    my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    $self->initProgressHandler ();

	my $rc = 1;
	my $args = $self->_buildArgs($instconfig);
	if (!defined $args){
		return undef;
	}
	push @$args, qw(-b );

	my $command = $self->getHdbInstallExecutable();
  	my $exer = new LCM::ProcessExecutor($command, $args);
    $exer->setOutputHandler($self->getProgressHandler ());
    my $environment = $self->prepareHdbInstallerEnvironment ();
    $exer->setProcessEnvironment ($environment);
    my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        my $action = $self->isUpdate ? 'Update' : 'Installation';
        $self->setErrorMessage ($action.' of ' . $self->getComponentName() . ' failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }
    
    if(!$isWin && $rc)
    {        
	    my $path = $self->getClientPath($instconfig);
	    my $defaultPath = $instconfig->getDefault("ClientPath");
	    if($path ne $defaultPath) {
	    	if(!symlink ($path, $defaultPath)){
        		$self->getMsgLst ()->addWarning("Cannot create symbolic link to the custom location $path.");
           	}
	    }
    }

	my $action = $self->isUpdate ? 'Update' : 'Install';
    $msg->endMessage (undef, $action. ' ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    
    return $rc;
}

1;
