package LCM::Component::Installable::LSS::LSSRoot;

use strict;
use LCM::ProcessExecutor;

use base 'LCM::Component::Installable::LSS::LSSBase';

sub _installLSSComponent {
    my ($self, $instconfig) = @_;
    my $executor = $self->createProcessExecutor($instconfig);
    return undef if !defined($executor);

    $executor->setOutputHandler($self->getProgressHandler());
    my $exitCode = $executor->executeProgram();

    $self->getMsgLst()->addMessage(undef, $executor->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($executor->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($executor->getOutputLines());
        $self->setErrorMessage ($self->_getEndMessage(0), ($errMsgLst->isEmpty() ? $executor->getErrMsgLst() : $errMsgLst));
        return undef;
    }
    return 1;
}

# Override
sub _buildArgs {
    my ($self, $instconfig) = @_;
    my $args = $self->SUPER::_buildArgs($instconfig);
    return undef if !defined($args);

    push @{$args}, '--read_password_from_stdin=xml';
    push @{$args}, '--batch';
    return $args;
}

sub createProcessExecutor{
    my ($self, $instconfig) = @_;
    my $command = $self->getHdbInstallExecutable();
    my $passwdInput = $self->getCustomPasswordInput($instconfig);
    my $args = $self->_buildArgs($instconfig);
    return undef if !defined($args);
    return LCM::ProcessExecutor->new($command, $args, $passwdInput);
}

1;