package LCM::Component::Installed::HDBServer;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::Globals qw($gLogDir $gProductNameEngine $gProductNameSHA);
use LCM::ProcessExecutor;
use LCM::SapHostAgentFunctions;
use LCM::Configuration::GenericStackAny qw ($ini_section_server);
use SDB::Install::DebugUtilities qw(dumpThings);
use strict;
use File::Basename qw (dirname);

use base 'LCM::Component::Installed';
use SDB::Install::Globals qw( $gHostRoleWorker
                             $gHostRoleStandby );

use constant CONVERT_MDC_STARTED=>'STARTED';
use constant CONVERT_MDC_FINISHED=>'FINISHED';

my $convertToMDCState = {
     STARTED => '0',
     FINISHED => '1',
};



sub getHdbInstallerDir{
    my ($self) = @_;
    if (!defined $self->{hdbInstallerDir}){
        $self->{hdbInstallerDir} = $self->{manifestDir} . $path_separator . 'bin';
    }
    return $self->{hdbInstallerDir};
}

sub uninstallComponent{
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $command = $self->getHdbUninstallExecutable();
    require SDB::Install::Configuration::ServerUninstParams;
    my $args = $instconfig->getCmdLineArgsFromInstconfig(new SDB::Install::Configuration::ServerUninstParams(),
                                       undef, $ini_section_server, 'hdbuninst');
    my $stdinLines = $instconfig->getXmlPasswordStream();
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    my $sid = $instconfig->getValue('SID');
    if ($sid) {
        push @$args, "--sid=$sid";
    }
    push @$args, "--instlog_dir=$gLogDir";
    push @$args, '-b';
	my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
	my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    } else {
        $self->removeComponentDirectory($self->{manifestDir});
    }
    
    if($rc && $instconfig->isDistributedSystem()) {
        $self->restartHostagent();
    }
    
    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub restartHostagent {
    my ($self) = @_;
    my $shaHelper = LCM::SapHostAgentFunctions->new($self);
    my $msg = $self->getMsgLst()->addMessage("Restarting $gProductNameSHA...");
    my $saveCntxt = $self->resetMsgLstContext();

    if (!$shaHelper->isHostagentInstalled()) {
        $msg->getSubMsgLst()->addMessage("$gProductNameSHA not available. Nothing to restart.");
    } elsif (!$shaHelper->restartSapHostAgent(1, 1)) {
        $msg->getSubMsgLst()->addMessage("Failed to restart $gProductNameSHA...");
    } else {
        $msg->getSubMsgLst()->addMessage("$gProductNameSHA restarted successfully.");
    }

    $self->setMsgLstContext($saveCntxt);
    return 1;
}

sub getComponentName {
	return $gProductNameEngine;
}

sub requireSystemRestart {
	return 1;
}

sub register{
    my ( $self, $logger,$instconfig,$sharedDir,$sid) = @_;
    
    my $remoteExecution = $instconfig->{options}->{remote_execution};
    if (defined $remoteExecution && $remoteExecution eq 'saphostagent') {
        return 1; 
    }
    if(!defined $logger){
        $logger = $self;
     }
    my $progressHandler;
    if($logger->can("getProgressHandler")){
    		$progressHandler = $logger->getProgressHandler();
    }    		
    my $sapSys = $instconfig->getCurrentSAPSystem ();
    my $binDir = $sapSys->get_globalTrexInstallDir();
    my $shellScript = $binDir . $path_separator .'bin'.$path_separator. 'hdbreg'; 
    
    my $args = [];
    push @$args, "--main", "SDB::Install::App::Console::DBUpgradeHost::main", "--batch";
    push @$args, '--instlog_dir=' . $gLogDir;
    my $stdinLines = $instconfig->getXmlPasswordStream(['Password']);
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    
    my $message = "Registering " . $self->getComponentName();
    my $msg = $logger->getMsgLst()->addProgressMessage( $message . "..." );
    my $saveContext =  $logger->setMsgLstContext([$msg->getSubMsgLst()]);
    my $executor = new LCM::ProcessExecutor($shellScript, $args, $stdinLines);
    $executor->setOutputHandler($progressHandler);
    $executor->setMsgLstContext($logger->getMsgLstContext());
    my $exitCode = $executor->executeProgram(1); 
    my $endMsg;
    my $rc;
    # Success exit code is 0
    if ( $exitCode == 0 ) {
        $endMsg = $message . " finished successfully";
        $rc = 1;
    } else {
        $endMsg = $message . " finished with error";
        $rc = 0;
    }
    $msg->endMessage ( undef, $endMsg);
    $logger->setMsgLstContext( $saveContext );
    
    return  $rc ;
}

sub getHostRoles {
    return [$gHostRoleStandby,$gHostRoleWorker];
}
sub setConvertToMultiDBState{
    my($self,$state) = @_;
    my $validState = $convertToMDCState->{$state};
    if(!defined $validState){
       die "$state is not a valid ConvertToMultiDB state";
    }
    $self->{_convertToMDC} = $convertToMDCState->{$state};
}

sub isConvertToMDCStarted{
    my $self = shift;
    return defined  $self->{_convertToMDC} ? ( $self->{_convertToMDC} == $convertToMDCState->{CONVERT_MDC_STARTED}) : 0;
}

sub getDeprecatedPlugins {
    return undef;
}

sub canBeSelectedForUninstall {
    return 0;
}

sub isSupportedByLSS {
    return 1;
}

sub getChecksumDir {
    my ($self) = @_;
    my $path = dirname($self->getManifest->getFileName());
    return File::Spec->catfile($path, '.checksum');
}

sub registerInLss {
    my ($self, $config) = @_;
    my $rc = $self->SUPER::registerInLss($config);
    if($rc && $config->getValue("LSSTrustUnsignedServer")){
        $rc = $self->modifyTrustLevelInLss($config);
    }
    return $rc;
}

1;
