package LCM::Component::Installed::HDBServerPlugin::HDBServerPluginBase;

use strict;
use parent 'LCM::Component::Installed';
use SDB::Install::Globals qw ($gKeynameEngine);

sub uninstallComponent{
    ...
}

sub getHdbUninstallExecutable{
    my ($self) = @_;
    if (!defined $self->{hdbUninstallExecutable}){
        my $componentMgr = $self->getComponentManager();
        my $server = $componentMgr->getComponentByKeyName($gKeynameEngine);

        return undef if (!defined $server);

        $self->{hdbUninstallExecutable} = $server->getHdbUninstallExecutable();
    }
    return $self->{hdbUninstallExecutable};
}

sub requireSystemRestart {
    my ($self) = @_;
    return $self->{requireSystemRestart} // 0;
}

sub shouldRestartSystemPostUninstall {
    my ($self, $configuration) = @_;
    my $isSecondarySystem = $configuration->getOwnInstance()->isSecondarySystem();
    if (!$self->requireSystemRestart() || $configuration->isPluginNoRestart() || $isSecondarySystem) {
        return 0;
    }

    return 1;
}

sub getSlppLogFileName {
	my ($self) = @_;
	return sprintf('%s.log', $self->getManifest()->getComponentKey());
}

sub isSupportedByLSS {
    return 1;
}

sub setRequireSystemRestart {
    my ($self, $needsRestart) = @_;
    $self->{requireSystemRestart} = $needsRestart;
}

sub getNumberOfExpectedOutputLines{
    my ($self) = @_;
    if ($self->requireSystemRestart()) {
        return 10;
    }
    return 2;
}

sub isDeprecated {
    my ($self,$config) = @_;
	my $serverComponent = $config->getComponentByBatchKey($LCM::Component::componentKeynameToBatchKey->{$gKeynameEngine});
    my $deprecatedPlugins = defined $serverComponent ? $serverComponent->getDeprecatedPlugins() : undef;
    return 1 if (defined $deprecatedPlugins && grep{ $self->getComponentBatchKey() eq $_} (keys %$deprecatedPlugins)) ;
    return 0;
}

1;
