package LCM::Component::Installed::LSS::LSSSidAdm;


use strict;
use SDB::Install::Globals qw($gLogDir);

use base 'LCM::Component::Installed::LSS::LSSBase';

sub _uninstallLSS {
    my ($self, $config) = @_;
    my $optionsMap = $self->_buildOptionsMap($config);
    return $self->_executeThroughSHAOperation($config, 'HdblcmLSSUninstall_v1', $optionsMap, undef, 1, 'Uninstallation');
}

sub _buildOptionsMap {
    my ($self, $config) = @_;

    my $optionsMap = {
        SID => $config->getSID(),
        KEEP_USER => $config->getValue('KeepLSSUser'),
        KEEP_USER_GROUP => $config->getValue('KeepLSSUserGroup'),
        LSS_INSTALLATION_PATH => $config->getValue('LSSInstallationPath'),
        INSTLOG_DIR => $gLogDir,
    };
    return $optionsMap;
}

sub removeRemoteLssInstances {
    my ($self, $config, $remoteHosts) = @_;
    my $optionsMap = $self->_buildOptionsMap($config);
    return $self->_executeThroughSHAOperation($config, 'HdblcmLSSRemoveHost_v1', $optionsMap, undef, 1, 'Uninstallation', undef, $remoteHosts);
}

1;
