# A class for installable components whose persistencies are
# created manually by us. Example: XSA Apps and CockpitStack
package LCM::Component::InternallyPersistedInstallable;
use parent qw(LCM::Component::Installable);
use strict;
use warnings;

use SDB::Install::Persistence::XMLGenerator;
use SDB::Install::MsgLst;
use LCM::FileUtils qw(writeToFile);


sub _install {
    ...
}

sub _update {
    ...
}

sub installComponent {
    my ($self, $configuration) = @_;
    my $xmlString = $self->createPersistenceXMLGenerator()->generatePersistenceXMLString();
    return
        $self->createPendingFile($configuration, $xmlString) &&
        $self->_install($configuration) &&
        $self->deletePersistenceFile($configuration);
}

sub updateComponent {
    my ($self, $configuration) = @_;
    my $xmlString = $self->createPersistenceXMLGenerator()->generatePersistenceXMLString();
    return
        $self->createPendingFile($configuration, $xmlString) &&
        $self->_update($configuration) &&
        $self->deletePersistenceFile($configuration);
}

1;