package LCM::ComponentManager::LogDetectedComponentsOutputHandler;

use strict;
use warnings;

use parent qw(SDB::Install::Base);

sub new {
    return bless({}, shift);
}

sub log {
    my($self, $msg) = @_;
    $self->getMsgLst()->addMessage($msg);
}

sub startLog {
    my($self, $msg) = @_;
    $self->log($msg);
}

sub endLog {
    my($self, $msg) = @_;
    $self->log($msg);
}

sub printDetectedComponents {
    my($self, $cfg, $componentList, $noCache) = @_;

    $self->setMsgLstContext($cfg->getMsgLstContext());
    $self->startLog("Scanning software locations...");

    if($noCache){
        $self->{_comp} = undef;
    }

    my $errorMsg = $cfg->getErrorString();

    if ( not scalar @{$componentList}) {
        if(!$errorMsg) {
            $self->endLog("No components were detected in the specified software locations.");
       }
       return;
    }

    if(!defined $self->{_comp}){
        $self->log("Detected components:");
    }

   foreach my $component ( @$componentList ) {
        if ($self->isPrintedComponent($component->getComponentKeyName())) {
                next;
        }

        $self->log(" " x 4 . $component->getComponentName() . " (" . $component->getVersion() . ")" . " in " . $component->getPath() );
        $self->addPrintedComponent($component->getComponentKeyName());
    }

    if($errorMsg) {
        $self->endLog("Warning:" . $errorMsg);
    }
}

sub addPrintedComponent {
    my($self, $componentKey) = @_;
    $self->{_comp} //= {};
    $self->{_comp}->{$componentKey} = $componentKey;
}

sub isPrintedComponent {
    my($self, $componentKey)  = @_;
    return $self->{_comp}->{$componentKey};
}

1;
