package LCM::Configuration::AcceleratorConfiguration;

use strict;
use parent qw(LCM::Configuration::GenericStackAny);
use SDB::Install::Globals qw ($gHostRoleAcceleratorWorker $gHostRoleAcceleratorStandby $gProductNameAccelerator);
use LCM::Configuration::ParametersCreator qw ( defineConstraintOfHanaOptionParam );
use LCM::Hosts::HostsDetector;
use SDB::Install::SysVars;
use LCM::FileUtils;

our $section = 'ets'; # accelerator section


sub defineAcceleratorParams{
    my ($self, $addUserAndPasswordParameters) = @_;
    if (defined $self->{acceleratorParamsDefined}){
        return 1;
    }

    $self->{acceleratorParamsDefined} = 1;
    my $order = scalar keys %{ $self->{params} };
    $self->{paramIds} = undef;    # reset ordered id list cache

    my $acceleratorParams = {
       'AcceleratorDataPath' => defineConstraintOfHanaOptionParam($self->getParamAcceleratorDataPath($order++, $section, 0, 1, 1), $gProductNameAccelerator),
       'AcceleratorLogPath'  => defineConstraintOfHanaOptionParam($self->getParamAcceleratorLogPath ($order++, $section, 0, 1, 1), $gProductNameAccelerator),
    };
	
	if($addUserAndPasswordParameters){
		$acceleratorParams->{AcceleratorUser}     = defineConstraintOfHanaOptionParam($self->getParamAcceleratorUser($order++, $section), $gProductNameAccelerator);
		$acceleratorParams->{AcceleratorPassword} = defineConstraintOfHanaOptionParam($self->getParamAcceleratorPassword($order++, $section), $gProductNameAccelerator);
	}
	
    map { $self->{params}->{$_} = $acceleratorParams->{$_} } keys %$acceleratorParams;
}

sub enableAcceleratorParams{
    my ($self, $on) = @_;
    if (!defined $on){
        $on = 1;
    }

    my $isUpdate = $self->isAcceleratorUpdate();
    my $shouldSkipPaths = !$on || $isUpdate;

    $self->setSkip('AcceleratorDataPath', $shouldSkipPaths);
    $self->setSkip('AcceleratorLogPath',  $shouldSkipPaths);

    my $addHostsValue = $self->getValue('AddHosts');
    my $shallAddAcceleratorHosts = (defined $addHostsValue
                    && ($addHostsValue =~ /$gHostRoleAcceleratorWorker|$gHostRoleAcceleratorStandby/));
    my $shouldSkipUserParameters = $self->isSkipped('AddHosts') || $shouldSkipPaths || !$shallAddAcceleratorHosts;

    if($self->shouldProvideAseUserCredentials()){
        $shouldSkipUserParameters = 0;
        $self->setType('AcceleratorPassword', 'passwd');
    }
    $self->setSkip('AcceleratorUser',  $shouldSkipUserParameters);
    $self->setSkip('AcceleratorPassword',  $shouldSkipUserParameters);

    return 1;
}

sub shouldProvideAseUserCredentials{
    my($self) = @_;
    return $self->isAcceleratorUpdate() && $self->existsEtsHost();
}

sub isAcceleratorUpdate{
    my ($self) = @_;

    my $acceleratorComponent =
            $self->{componentManager}->getComponentByBatchKey("ets");

    if (defined $acceleratorComponent
        && $acceleratorComponent->isComponentSelected()
        && $acceleratorComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub isAcceleratorNewInstall{
    my ($self) = @_;

    my $acceleratorComponent =
            $self->{componentManager}->getComponentByBatchKey("ets");

    if (defined $acceleratorComponent
        && $acceleratorComponent->isComponentSelected()
        && !$acceleratorComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub checkAcceleratorDataPath {
    return $_[0]->checkHanaOptionsPathParam('AcceleratorDataPath', $_[1]);
}

sub checkAcceleratorLogPath {
    return $_[0]->checkHanaOptionsPathParam('AcceleratorLogPath', $_[1]);
}

sub existsEtsHost {
    my ($self) = @_;
    my $hostDetector = new LCM::Hosts::HostsDetector(undef, $self->getMsgLstContext(), $self->getOwnInstance());
    return (scalar(@{$hostDetector->getHostsWithRoles([$gHostRoleAcceleratorWorker,$gHostRoleAcceleratorStandby])})>0)?1:0 ;
}
1;