package LCM::Configuration::ActionConfiguration;

use strict;
use SDB::Install::Configuration;

our @ISA = qw (SDB::Install::Configuration Exporter);

sub new {
	my $self  = shift->SUPER::new(@_);
	my $order = 0;
	$self->{params}->{'Action'} = getParamAction($order);
	return $self;
}

sub getParamAction {
	my ($order) = @_;
	return {
		'order'                       => $order++,
		'opt'                         => 'action',
		'type'                        => 'string',
		'value'                       => undef,
		'default'                     => 'exit',
		'set_interactive'             => 1,
		'may_be_interactive'          => 0,
		'init_with_default'           => 0,
		'section'                     => 'Action',
		'str'                         => 'Action',
		'desc'                        => 'Specifies the action to be performed',
		'mandatory'                   => 0,
		'interactive_index_selection' => 1,
		'interactive_str'             => 'selected action index',
		'console_text'                => "Choose an action\n",
		'action_switch'               => 1,
		'help_switch_usage'           => '[--pass_through_help]',
		'skip_help_valid_values'      => {'uninstall'       => 1},
	};
}

sub setValidActions {
	$_[0]->{params}->{'Action'}->{'valid_values'} = $_[1];
}

sub getValidActions{
	my ( $self ) = @_;
	return $self->{params}->{'Action'}->{'valid_values'};
}

sub setActionUIValues {
	$_[0]->{params}->{'Action'}->{ui_values} = $_[1];
}

sub getActionUIValues{
	my ( $self ) = @_;
	return $self->{params}->{'Action'}->{ui_values};
}

sub getAction {
	return $_[0]->getValue('Action');
}

sub getParamByOpt {
	my ($self, $opt) = @_;

	for (keys %{$self->{params}}) {
		next if !defined $self->{params}->{$_}->{opt};
		return $self->{params}->{$_} if ($self->{params}->{$_}->{opt} eq $opt);
	}
	return undef;
}

sub printActionHeaderMessage{
	#Override in children
	return undef;
}

sub getOwnInstance {
# No instance is available at this time
# Method introduced due to Bug: 79760
	return undef;
}

sub isBootstrapFromResident {
    my ($self) = @_;
    return $self->getValue('BootstrapFromResident');
}

sub _setActionsDetector {
    my ($self, $actionsDetector) = @_;
    $self->{_actionsDetector} = $actionsDetector;
}

sub getActionsDetector {
    my ($self) = @_;
    return $self->{_actionsDetector};
}

1;
