package LCM::Configuration::AutoInitializeFamilyServicesConfiguration;

use strict;
use warnings;
use SDB::Install::Configuration::AutoInitFamilyServicesParamHandler;
use SDB::Install::Globals qw (GetAutoInitializeServicesRolesComponentMap
                              $gHostRoleEsWorker );
use LCM::HostsParser qw(ExtractLocalAndRemoteHosts);

sub getAutoInitFamilyServicesParameterHanlder {
    my ( $self, $paramId ) = @_;
    return SDB::Install::Configuration::AutoInitFamilyServicesParamHandler->new($paramId);
}

sub getFamilyComponentsWithAutoInitServices {
    my $self                   = shift;
    my $systemComponentManager = $self->getSystemComponentManager();
    return [] if (!defined $systemComponentManager);

    my @matchedComponents = grep { $_->isFeatureSupported('auto_initialize_services') } @{$systemComponentManager->getAllComponents};
    return \@matchedComponents;
}

sub isHostRoleAutoInitServicesApplicable{
    my ($self,$role) = @_;
    my $componentsWithAutoInitializeServices = $self->getFamilyComponentsWithAutoInitServices();
    my $validAutoInitializeServicesRolesComponentMap = GetAutoInitializeServicesRolesComponentMap();
    my $validComponetForRole = $validAutoInitializeServicesRolesComponentMap->{$role};                         
    return 0 if(!defined $validComponetForRole) ;                       
    my $matches = grep{$_->getComponentKeyName() eq $validComponetForRole}@{$componentsWithAutoInitializeServices};
    if ( $matches > 0 ){
       $self->setRequiresTenantUserCredentials($role);
       return 1;
    }
}

sub checkRequiresTenantUserCredentials{
    my ($self) = @_;
    return $self->{_requiresTenantUserCredentials};
}

sub setRequiresTenantUserCredentials{
    my ($self,$role) = @_;
    if($role ne $gHostRoleEsWorker){
       $self->{_requiresTenantUserCredentials} = 1;
    } else{
       $self->{_requiresTenantUserCredentials} = 0;
    }
}

sub isRemoveHostsValueApplicableForAutoInitialize {
    my($self,$paramId,$valKey,$value) = @_;
    return 0 if ($paramId ne 'RemoveHosts');
    my $trexInstance = $self->getOwnInstance();
    my @hostsToRemove = split(',', $value);
    for my $host (@hostsToRemove) {
        my $hostRoles = $trexInstance->getHostRolesByIniFile($host);
        return 1 if (grep {$self->isHostRoleAutoInitServicesApplicable($_)} @$hostRoles);
    }
    return 0;
}

sub isAddHostsValueApplicableForAutoInitialize {
    my($self,$paramId,$valKey,$value) = @_;
    return 0 if ($paramId ne 'AddHosts');
    my ($localHostInputString, $remoteHostsInputString) = ExtractLocalAndRemoteHosts($value, $self);
    my $hostsParser = new LCM::HostsParser();
    my ($rc, $parserErrMsgLst) = $hostsParser->parse($localHostInputString);
    if (defined $localHostInputString && !defined $rc) {
        return 0;
    }
    my $hosts = $hostsParser->getHosts();
    my $localHost = $hosts->[0];
    my $localRoles = $hostsParser->getRoles($localHost);
    return 1 if(grep {$self->isHostRoleAutoInitServicesApplicable($_)} @$localRoles);
    ($rc, $parserErrMsgLst) = $hostsParser->parse($remoteHostsInputString);
    if (!defined $rc) {
        return 0;
    }
    my $remoteHosts = $hostsParser->getHosts();
    foreach my $host(@$remoteHosts){
        my $remoteRoles = $hostsParser->getRoles($host);
        return 1 if(grep {$self->isHostRoleAutoInitServicesApplicable($_)} @$remoteRoles);
    }
    return 0;
}

sub isAddRolesValueApplicableForAutoInitialize {
    my($self,$paramId,$valKey,$value) = @_;
    return 0 if(($paramId ne 'AddRoles') && ($paramId ne 'RemoveRoles') && ($paramId ne 'AddLocalRoles'));

    for my $role (split(',', $value)) {
        return 1 if $self->isHostRoleAutoInitServicesApplicable($role);
    }
    return 0;
}

1;
