package LCM::Configuration::ES::ESConfiguration;

use parent qw(LCM::Configuration::GenericStackAny);
use SDB::Install::Globals qw ($gProductNameEs);
use LCM::Configuration::ParametersCreator qw ( defineConstraintOfHanaOptionParam );
use SDB::Install::SysVars;
use LCM::FileUtils;
use strict;

our $section = 'es';


sub defineEsParams{
    my ($self) = @_;
    if (defined $self->{esParamsDefined}){
        return 1;
    }

    $self->{esParamsDefined} = 1;
    my $order = scalar keys %{ $self->{params} };
    $self->{paramIds} = undef;    # reset ordered id list cache
    
    my $esParams = {
       'EsDataPath' => defineConstraintOfHanaOptionParam($self->getParamEsDataPath ($order++, $section, 0, 1, 1), $gProductNameEs),
       'EsLogPath'  => defineConstraintOfHanaOptionParam($self->getParamEsLogPath  ($order++, $section, 0, 1, 1), $gProductNameEs),
    };
    map { $self->{params}->{$_} = $esParams->{$_} } keys %$esParams;
}

sub enableEsParams {
    my ($self, $shouldEnable) = @_;
    my $isUpdate = $self->isEsUpdate();
    my $shouldSkipPaths = !$shouldEnable || $isUpdate;

    $self->setSkip('EsDataPath', $shouldSkipPaths);
    $self->setSkip('EsLogPath', $shouldSkipPaths);
}

sub isEsUpdate{
    my ($self) = @_;
    my $esComponent = $self->{componentManager}->getComponentByBatchKey("es");
    if (defined $esComponent && $esComponent->isComponentSelected() && $esComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub isEsNewInstall{
    my ($self) = @_;
    my $esComponent = $self->{componentManager}->getComponentByBatchKey("es");
    if (defined $esComponent && $esComponent->isComponentSelected() && !$esComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub checkEsDataPath {
    return $_[0]->checkHanaOptionsPathParam('EsDataPath', $_[1]);
}

sub checkEsLogPath {
    return $_[0]->checkHanaOptionsPathParam('EsLogPath', $_[1]);
}

1;