package LCM::Configuration::EngineExternalActionConfigurationFactory;

use strict;
use warnings;
use LCM::Configuration::GenericStackSystemCollection;
use LCM::Configuration::HdblcmExternalSelectedSystemValuesBuilder;

use parent qw(LCM::Configuration::AbstractExternalConfigurationFlavourFactory);

sub new{
    my($class,$actionConfig,$flavour) = @_;
    my $self = bless({},$class);
    $self->{actionConfig} = $actionConfig;
    $self->{flavour} = $flavour;
    return $self;
}

sub getProductName{
    my $self = shift;
    SDB::Install::Globals::getFlavourProductName($self->getEngineFlavour())
}

sub getValidActions{
    return ['install','update','extract_components','print_detected_components'];
}

sub createSystemCollection{
    my $self = shift;
    return LCM::Configuration::GenericStackSystemCollection->new($self->getActionConfig());
}

sub createSelectedSystemsValuesBuilder{
    my $self = shift;
    return  LCM::Configuration::HdblcmExternalSelectedSystemValuesBuilder->new($self->getActionConfig());
}

sub getActionConfig{
    my $self = shift;
    return $self->{actionConfig};
}

sub getEngineFlavour{
    my $self = shift;
    return $self->{flavour};
}
1;
