package LCM::Configuration::GenericStackConfigurationFactory;

use strict;

use SDB::Install::System qw(isSidadmin isAdmin);
use SDB::Install::Globals qw($gFlavourCockpit $gFlavourPlatform);
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use LCM::Utils::CommonUtils qw(findAutoConfiguration);

my $instance;

sub getInstance {
    if ( !defined $instance ) {
        $instance = LCM::Configuration::GenericStackConfigurationFactory->_new();
    }
    return $instance;
}

sub _new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub createInstallConfiguration{
    my ( $self,$application) = @_;
    require LCM::Configuration::GenericStackInstallConfiguration;
    my $config = LCM::Configuration::GenericStackInstallConfiguration->new($application->{options}, $application->{configfile});
    my $isCockpitInstallationKit = ($application->getFlavour() eq $gFlavourCockpit) ? 1 : 0;
    $config->setIsCockpitConfiguration($isCockpitInstallationKit);
    my $actionConfig = $application->getActionConfiguration();
    $self->_setComponentFsRoot($actionConfig, $config);
    return $config;
}

sub createUpdateConfiguration{
    my ($self, $application) = @_;
    my $actionConfig = $application->getActionConfiguration();
    my $isAutoConfigurationDetected = 0;
    my $configfile = $application->{configfile};
    if (!$configfile) {
        $configfile = $self->_detectAutoConfigFile($actionConfig);
        $isAutoConfigurationDetected = $configfile ? 1 : 0;
    }

    my $config = undef;
    my $installedServerFlavour = $self->_detectInstalledSystemFlavour($actionConfig);
    my $isCockpitInstallationKit = ($application->getFlavour() eq $gFlavourCockpit) ? 1 : 0;

    if ($isCockpitInstallationKit && ($installedServerFlavour eq $gFlavourPlatform)) {
        require LCM::Configuration::Cockpit::CockpitOnHANAConfiguration;
        $config = LCM::Configuration::Cockpit::CockpitOnHANAConfiguration->new($application->{options}, $configfile);
    } else {
        require LCM::Configuration::GenericStackUpdateConfiguration;
        $config = LCM::Configuration::GenericStackUpdateConfiguration->new($application->{options}, $configfile);
    }

    $config->setIsCockpitConfiguration($isCockpitInstallationKit);
    $config->setAutoConfigDetected($isAutoConfigurationDetected);
    $self->_initializeUpdateConfiguration($actionConfig, $config);
	return $config;
}

sub _initializeUpdateConfiguration {
    my ($self, $actionConfig, $config) = @_;
    my $sid = $actionConfig->getValue('Action_SID');
    if ( defined $sid ) {
        $config->{params}->{'SID'}->{batchValue} = $sid;
    }
    my $skipHostagentCalls = $actionConfig->getValueOrBatchValue('SkipHostagentCalls'); 
    if (defined $skipHostagentCalls) {
        $config->setValue('SkipHostagentCalls', $skipHostagentCalls);
    }
    $self->_setRemoteExecution($config, $actionConfig);
    $self->_setComponentFsRoot($actionConfig, $config);
}

sub _setComponentFsRoot {
    my ($self, $actionConfig, $config) = @_;
    my $addCmpsLocation = $actionConfig->getValue('AddComponentsLocation');
    if ($actionConfig->isBootstrapFromResident() || defined $addCmpsLocation) {
        $config->setInteractive('ComponentFsRoot', 0);
        $config->setInteractive('AddComponentsLocation', 0);
    } else {
        $config->setInteractive('AddComponentsLocation', $actionConfig->isInteractive('AddComponentsLocation'));
    }
}

sub createUpdateResidentConfiguration {
	my ($self,$application) = @_;

	require LCM::Configuration::GenericStackUpdateResidentConfiguration;
	my $config = new LCM::Configuration::GenericStackUpdateResidentConfiguration( $application->{options}, $application->{configfile} );
    my $actionConfig = $application->getActionConfiguration();
    $self->_setRemoteExecution($config, $actionConfig);

	return $config;
}

sub createExtractComponentsConfiguration {
    my ($self, $application) = @_;
    require LCM::Configuration::ExtractComponentsConfiguration;
    my $config = new LCM::Configuration::ExtractComponentsConfiguration($application->{options}, $application->{configfile});
    return $config;
}

sub createPrintDetectedComponentsConfiguration {
    my ($self, $application) = @_;
    require LCM::Configuration::PrintDetectedComponentsConfiguration;
    return new LCM::Configuration::PrintDetectedComponentsConfiguration($application->{options}, $application->{configfile});
}

sub _setRemoteExecution {
	my ($self, $config, $actionConfig) = @_;

    my $remoteExecution = $actionConfig->getValueOrBatchValue('RemoteExecution');
    if ( defined $remoteExecution ) {
        $config->setValue('RemoteExecution', $remoteExecution);
    }
}

sub _detectAutoConfigFile {
    my ($self, $actionConfig) = @_;
    my $action = $actionConfig->getAction();
    my $flavour = $self->_detectInstalledSystemFlavour($actionConfig);
    return findAutoConfiguration($action, $flavour) // findAutoConfiguration(undef, $flavour);
}

sub _detectInstalledSystemFlavour {
    my ($self, $actionConfig) = @_;
    my $sid = $actionConfig->getValue('Action_SID');
    my $system = $sid ? CollectSAPSystems()->{$sid} : undef;
    return $system ? $system->getHANAFlavour() : $gFlavourPlatform
}

return 1;
