package LCM::Configuration::Hosts::AddHosts::Validators::LSS::BaseCheck;

use strict;
use warnings;
use SDB::Install::LSS::LssInstance;
use SDB::Install::Globals qw($gHostRoleStandby $gHostRoleWorker);

use parent qw(SDB::Install::Base);

sub new {
    my $self = bless({},shift);
    my($paramID) = @_;
    $self->{_paramId} = $paramID;
    return $self;

}

sub setConfiguration {
    my($self,$cfg) = @_;
    $self->setMsgLstContext($cfg->getMsgLstContext());
    $self->{cfg} = $cfg;
}

sub getConfiguration {
    my($self) = @_;
    return $self->{cfg};
}

sub validateInteractiveDbRole {
    my($self, $cfg, $host) = @_;
    $self->setConfiguration($cfg);
    if(!$cfg->isInteractiveAddHostInput()){
        return 1;
    }

    if($self->shouldCheck()){
        return $self->check([$host]);
    }
    return 1;
}

sub onValueChange {
    my ($self, $value, $cfg) = @_;
    # The listener is attached to RootUser/RootPassword, which are after 'AddHosts' and in interactive mode the 'AddHost'
    # value for the roles is read from the custom input function and is validated via the validateInteractiveDbRole;
    if($cfg->isInteractiveAddHostInput()){
            return 1;
    }

    $self->setConfiguration($cfg);
    my $hostNamesToCheck;

    # Handles the case for local host not part of the system
    if(defined $self->{_paramId} && $self->{_paramId} =~ 'HostRoles'){
        return 1 if($value !~ /$gHostRoleWorker|$gHostRoleStandby/);
        $hostNamesToCheck = [$cfg->getLocalHanaHost()];
    } else {
        $hostNamesToCheck = $cfg->getAdditionalHanaHosts();
        return 1 if(!defined $hostNamesToCheck || scalar(@$hostNamesToCheck) == 0);
    }

    if($self->shouldCheck()){
        if(!$self->check($hostNamesToCheck)){
            if(defined $self->{_paramId}){
                $cfg->setNoRetry($self->{_paramId},1);
            }
            return 0;
        }
    }

    return 1;
}

sub shouldCheck {
    my ($self ) = @_;
    my $cfg = $self->getConfiguration();
    my $lssInstance = $cfg->getLssInstance();
    return defined $lssInstance;
}

sub check() {
    ...
}

1;

