package LCM::Configuration::Hosts::AddHosts::Validators::LSS::OSUserCheck;

use strict;
use warnings;
use SDB::Common::Utils qw(getSidcryptName checkOsGroupID checkOsUserID);
use SDB::Common::BuiltIn;
use SDB::Install::Globals qw($gSapsysGroupName $gHostRoleWorker $gHostRoleStandby);

use parent qw(LCM::Configuration::Hosts::AddHosts::Validators::LSS::BaseCheck);


sub check {
    my ($self, $hostNames) = @_;
    $hostNames //= $self->getConfiguration()->getAdditionalHanaHosts();
    if(!($self->_checkSidcryptGid($hostNames) && $self->_checkSidcryptUid($hostNames))){
        return undef;
    }
    return 1;
}

sub shallSkipLocalHostCheck {
    my($self, $hostNames) = @_;
    my $localHost = $self->getConfiguration()->getLocalHanaHost();
    return (grep{$localHost eq $_} @$hostNames) ? 0 : 1 ;
}

sub _checkSidcryptGid {
    my ($self, $hostNames) = @_;
    my $cfg = $self->getConfiguration();
    my $sapsys = $cfg->getSAPSystem();
    my $lssInstance = $cfg->getLssInstance();
    return 0 if(!defined $lssInstance);
    my $sidCryptCfg = $lssInstance->getUserConfig($sapsys);
    my $sidCryptGID = $sidCryptCfg->getGID();
    my $sidcryptGroupName = $sidCryptCfg->getGroupName();
    if(!defined $sidCryptGID || $sidCryptCfg->errorState()){
        $self->getErrMsgLst()->appendMsgLst($sidCryptCfg->getErrMsgLst());
        return 0;
    }
    return 0 if(!$self->_checkGroupName($hostNames, $sidCryptGID, $sidcryptGroupName));
    my $noLocalHostCheck = $self->shallSkipLocalHostCheck($hostNames);
    return 0 if (!SDB::Common::Utils::checkOsGroupID($cfg, 'AddHosts', $sidcryptGroupName, $sidCryptGID, $noLocalHostCheck, $hostNames));
    return 1;
}

sub _checkGroupName {
    my ($self, $hostNames, $sidCryptGID, $sidcryptGroupName) = @_;
    my $cfg = $self->getConfiguration();
    my $defaultName = getSidcryptName($cfg->getSID());
    if($sidcryptGroupName eq $gSapsysGroupName){
        $self->appendErrorMessage("Primary group of user '$defaultName' cannot be '$gSapsysGroupName'");
        return 0;
    }

    my $lssGroups = $cfg->{remoteGids}->{$sidCryptGID} // [];
    my @hostsWithLssGroup = ();
    foreach my $host (@{$hostNames}) {
        push @hostsWithLssGroup, $host if(grep{ $_->[0] eq $host} @{$lssGroups});
    }

    if(!$self->shallSkipLocalHostCheck($hostNames)){
        my $localHost = $self->getConfiguration()->getLocalHanaHost();
        my $exists = defined(SDB::Common::BuiltIn->get_instance()->getgrgid($sidCryptGID)) ? 1 : 0;
        push @hostsWithLssGroup, $localHost if($exists);
    }

    my $isMissingGroup = @hostsWithLssGroup != @{$hostNames};
    if($isMissingGroup && $sidcryptGroupName ne $defaultName){
        $self->appendErrorMessage("If you want to use group different from '$defaultName', ensure that it exists on all hosts with $gHostRoleWorker and $gHostRoleStandby roles.");
        return 0;
    }
    return 1;
}

sub _checkSidcryptUid {
    my ($self, $hostNames) = @_;
    my $cfg = $self->getConfiguration();
    my $sapsys = $cfg->getSAPSystem();
    my $lssInstance = $cfg->getLssInstance();
    return 0 if(!defined $lssInstance);
    my $sidCryptCfg = $lssInstance->getUserConfig($sapsys);
    my $sidCryptUID = $sidCryptCfg->getUID();
    if(!defined $sidCryptUID || $sidCryptCfg->errorState()){
        $self->getErrMsgLst()->appendMsgLst($sidCryptCfg->getErrMsgLst());
        return 0;
    }
    my $sidCryptName = getSidcryptName($cfg->getSID());
    my $noLocalHostCheck = $self->shallSkipLocalHostCheck($hostNames);
    return 0 if (!SDB::Common::Utils::checkOsUserID($cfg, 'AddHosts', $sidCryptName, $sidCryptUID, 0, $noLocalHostCheck, $hostNames));
    return 1;
}

1;