package LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Rename;
use strict;
use base qw ( LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario );
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager;
use LCM::Component;
use SDB::Install::Globals qw ($gKeynameHLM);

sub detectSkippedComponents{
    my($self) = @_;
    my $componentsManager = $self->{oComponentsManager};
    my $installedComponents = $componentsManager->{aInstalledComponents};
    foreach my $installedComponent(@$installedComponents){
        if($componentsManager->shallSkipComponent($installedComponent)){
            $componentsManager->skipComponent($installedComponent);
        }
    }
}

sub getRemoteRegistrableComponents{
	my ($self) = @_;
	my $remoteComponentsForRegistration = $self->SUPER::getRemoteRegistrableComponents();
	push(@{$remoteComponentsForRegistration}, $gKeynameHLM);
	return $remoteComponentsForRegistration ;
}

return 1;