package LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager;

use strict;
use LCM::Component;
use base qw (Exporter);
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario;
use Carp;

our $SCENARIO_ADD_REMOVE_HOSTS = 4;
our $SCENARIO_INSTALL = 1;
our $SCENARIO_UNINSTALL = 2;
our $SCENARIO_RENAME = 3;

our @EXPORT_OK = qw(
    $SCENARIO_INSTALL
    $SCENARIO_UNINSTALL
    $SCENARIO_RENAME
    $SCENARIO_ADD_REMOVE_HOSTS);
    
sub new {
	my ($class,$selectedComponents,$installedComponents,$scenario) = @_;
	my $self = {};
	bless $self, $class;
	$self->{oScenario} = undef;
	$self->{aSelectedComponents} = $selectedComponents;
	$self->{aInstalledComponents} = $installedComponents;
	$self->{mSkippedComponents} = ();
	$self->setScenario($scenario);
    return $self;
}

sub setScenario{
    my($self,$type) = @_;
    if($type ==  $SCENARIO_INSTALL){
    	require LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Install;
    	$self->{oScenario} = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Install($self);
    }
    elsif($type == $SCENARIO_UNINSTALL){
    	require LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Uninstall;
    	$self->{oScenario} = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Uninstall($self);
    }
    elsif($type == $SCENARIO_ADD_REMOVE_HOSTS){
    	require LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::AddRemoveHost;
    	$self->{oScenario} = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::AddRemoveHost($self);
    }
    elsif($type == $SCENARIO_RENAME){
    	require LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Rename;
        $self->{oScenario} = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::Scenario::Rename($self);
    }
    else{
    	croak "Unsupported scenario for components registration";
    }
}   

sub shallSkipComponent{
    my($self,$component) = @_;
    my $componentKeyname = $component->getComponentKeyName();
    my $registrables = $self->getRegistrableComponents();
    if( grep { $_ eq $componentKeyname } @$registrables ){
        return 0;
    }
    return 1;
}

sub skipComponent{
    my($self,$component) = @_;
    if ( ! defined $self->{mSkippedComponents} ) {
        $self->{mSkippedComponents} = ();
    }
    if ( ! exists( $self->{mSkippedComponents}->{ $component->getComponentKeyName() } )){
        $self->{mSkippedComponents}->{$component->getComponentKeyName()} = $component;
    }
    
}

sub getSkippedComponents{
    my($self) = @_;
    if ( ! defined $self->{mSkippedComponents} ) {
        return undef;
    }
    
    my @skipped =  values %{$self->{mSkippedComponents}};
    return \@skipped;
}

sub existRegistrableComponents {
    my ($self) = @_;
    for my $registrable ( @{$self->{aSelectedComponents}} ){
       if ( ! $self->shallSkipComponent( $registrable ) ) {
           return  1;
       }
    }
    return 0;
}

sub detectComponents{
	my ($self) = @_;
	$self->{oScenario}->detectSkippedComponents(); 
}

sub getRegistrableComponents{}

sub isComponentSelected{
    my($self,$component) = @_;
    if( grep { $_->getComponentKeyName() eq $component->getComponentKeyName() } @{$self->{aSelectedComponents}} ){
        return 1;
    }
    
    return 0;
}

1;
