package LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationFactory;

use strict;
use SDB::Install::Configuration;
use LCM::Component;
use SAPDB::Install::Hostname;
use LCM::Configuration::Hosts::UpdateHosts::GenericStackUpdateHostConfiguration;
use LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration;
use LCM::Configuration::Hosts::UpdateHosts::UpdateRemoteHostConfiguration;
use LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfigurationWithSHA;
use LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationInRename;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::SkippedComponentsManager qw ( $SCENARIO_RENAME );
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager;
use LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager;
use LCM::HostsParser;

sub createLocalConfiguration{
    my($self, $primaryConfig, $paramHash, $isBeforeRename) = @_;
    my $sid = $primaryConfig->getValue('SID');
    my $installer = new LCM::Installer();
    my $updateHostConfig;
    if(!$installer->isInstalled()){
        $updateHostConfig =  LCM::Configuration::Hosts::UpdateHosts::GenericStackUpdateHostConfiguration->new();
        $updateHostConfig->setValue('SID', $sid);
        $updateHostConfig->setValue('Target', $primaryConfig->getValue('Target'));
        _setLocalHostname($updateHostConfig, $primaryConfig);
    }  else {
        if(defined  $primaryConfig->{params}->{'HostagentPassword'} && !$primaryConfig->isSkipped('HostagentPassword')){
            $updateHostConfig = LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfigurationWithSHA->new();
            $updateHostConfig->setValue('HostagentPassword', $primaryConfig->getValue('HostagentPassword'));
        } else {
            $updateHostConfig = LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration->new();
        }
        $updateHostConfig->setValue('SID', $sid);
# This flas is used to help filter an error message stating that there
# is no system with the <renamedSid> on the slave host in case of scope=instance
# It is needed because the UpdateHosts configurations are used for many scenarios
# and there is no particular way to distinguish a rename with scope=instance
        $updateHostConfig->{isBeforeRenameWithContinue} = $primaryConfig->{isContinueOption} if ($isBeforeRename);
        $updateHostConfig->detectSystemComponents();
    }
     $self->_setParameters($updateHostConfig, $primaryConfig, $paramHash);
     return $updateHostConfig;
}

sub _setParameters{
	my($self, $config,$instconfig,$paramHash) = @_;
	$config->setMsgLstContext($instconfig->getMsgLstContext());
    $config->setValue('RemoteExecution', $instconfig->getValue('RemoteExecution'));
    my $skippedComponentsStr = _buildSkippedComponentsString($paramHash->{SkippedComponents});
    if(defined $skippedComponentsStr){
        $config->setValue('SkippedComponents', $skippedComponentsStr);
    }
    $config->setValue('GenerateCertificates', 'off');
    $config->setValue('DeploySHAConfigurations',$paramHash->{DeployShaConfigurations});
    $config->setValue('UpdateComponentListLocation',$paramHash->{UpdateComponentListLocation});
    
    if($paramHash->{GenerateCertificates}){
       _setLocalHostname($config,$instconfig);
		$self->_setLocalCertificateHostName($config, $instconfig->getValue('CertificatesHostmap'), $instconfig->{'params'}->{'CertificatesHostmap'}->{'default_map'});
		$config->setValue('GenerateCertificates', 1);
    }
    
    my $componentRegistration = $paramHash->{ComponentsRegistration};
    if(!defined $componentRegistration){
        $componentRegistration = 'none';
    }
    $config->setValue('ComponentsRegistration', $componentRegistration);   
    
    $config->setValue('Password',$instconfig->getValue('Password'));
    my $useHttp = $instconfig->getValue('UseHttp');
    my $sso_cert = $instconfig->getValue('SSOCertificate');
    if (defined $useHttp){
        $config->setValue('UseHttp', $useHttp);
    }
    if (defined $sso_cert){
        $config->setValue('SSOCertificate', $sso_cert);
    }
    my $sqlpasswd = $instconfig->getValue('SQLSysPasswd');
    if (defined $sqlpasswd){
        my $systemUser = $instconfig->getValue('SystemUser');
        $config->setValue('SystemUser', $systemUser) if (defined $systemUser);
        $config->setValue('SQLSysPasswd', $sqlpasswd);
        if (exists $config->{params}->{CollectUpdateHostCredentials}) {
            $config->setValue('CollectUpdateHostCredentials', 1);
        }
    }
    my $skipHostagentCalls = $instconfig->getValue('SkipHostagentCalls');
    if (defined $skipHostagentCalls) {
        $config->setValue('SkipHostagentCalls', $skipHostagentCalls);
    }
    $config->setValue('SkipModifySudoers', $instconfig->getValue('SkipModifySudoers'));
}

sub createLocalConfigurationAfterRename{
    my($self,$sidadmPassword, $instconfig, $paramHash) = @_;
    my $skippedComponents;
    if($paramHash->{ComponentsRegistration}){
    	$skippedComponents = _getSkippedComponentsByScenario(0,$SCENARIO_RENAME,$instconfig->getSystemComponentManager());
    }
    $paramHash->{SkippedComponents} = $skippedComponents;
    my $config = new LCM::Configuration::Hosts::UpdateHosts::UpdateHostConfigurationInRename();
    $self->_setParameters($config, $instconfig, $paramHash);   
    $config->setValue('Password',$sidadmPassword);
    $config->setValue('SID',$instconfig->getValue('newSID'));
    if($instconfig->isLocalhostNameChanged()){
        $config->{localHostname} = $instconfig->getChangedLocalhostName();
        $self->_setLocalCertificateHostName($config, $instconfig->getValue('CertificatesHostmap'), $instconfig->{'params'}->{'CertificatesHostmap'}->{'default_map'});
    }
    $config->{sapSys} = $instconfig->getSAPSystem();
    $config->detectSystemComponents();
    return $config;
}

sub createRemoteConfiguration{
    my($self, $instconfig, $remoteHostsObjects, $paramHash, $newSid) = @_;
    my $config = LCM::Configuration::Hosts::UpdateHosts::UpdateRemoteHostConfiguration->new();
    $config->setMsgLstContext($instconfig->getMsgLstContext());
    $config->setRemoteHosts($remoteHostsObjects);
    if (defined $newSid) {
        $config->setValue('SID', $newSid);
    } else {
        $config->setValue('SID',$instconfig->getValue('SID'));     
    }

    my $target = $instconfig->getValue('Target');
    if ( ! defined $target ) {
        $target = $instconfig->getSAPSystem()->get_target();
    }
    $config->setValue('Target',$target);
    my $skippedComponentsStr = _buildSkippedComponentsString($paramHash->{SkippedComponents});
    if(defined $skippedComponentsStr){
        $config->setValue('SkippedComponents', $skippedComponentsStr);
    }
    $config->setValue('DeploySHAConfigurations', $paramHash->{DeployShaConfigurations});
    $config->setValue('UpdateComponentListLocation', $paramHash->{UpdateComponentListLocation});
    $config->setValue('GenerateCertificates', 0);

    my $remoteHostnames ; 
    if(defined($remoteHostsObjects) && scalar(@{$remoteHostsObjects}) > 0){
        $remoteHostnames = [];
        for my $remoteHosts (@{$remoteHostsObjects}){
            push(@{$remoteHostnames}, @{$remoteHosts->getHostNames()});
        }
    }
    my %hostNamesMap = map { $_ => 1 } @{$remoteHostnames};

    my $shallSkipPassword = ($paramHash->{GenerateCertificates} || $paramHash->{DeployShaConfigurations}) ? 0 : 1;
    $config->setSkip('Password', $shallSkipPassword);

    if($paramHash->{GenerateCertificates}){
        $config->setSkip('CertificatesHostmap', 0);
        $config->setValue('GenerateCertificates', 1);
        my $certificatesMap = $instconfig->{params}->{'CertificatesHostmap'}->{value};
        my $certificatesDefaultMap = $instconfig->{params}->{'CertificatesHostmap'}->{default_map};

        foreach my $hostName (keys %{$certificatesMap}) {
            next if(!exists($hostNamesMap{$hostName}));

            my $value = $certificatesMap->{$hostName};
            my $defaultValue = $certificatesDefaultMap->{$hostName};

# Don't provide certificate value to executor, if user didn't changed default value.
# This is more error safe, due to possibility to regenerate certificates with default values which are incorrectly detected.
            if ((defined $value) && ($value ne '') && ($value ne $defaultValue)) {
                $config->setMapValueItem('CertificatesHostmap',$hostName,$value);
            }
        }
    }
    $config->setValue('RemoteExecution',$instconfig->getValue('RemoteExecution'));
    if ( !defined $paramHash->{ComponentsRegistration} ) {
        $paramHash->{ComponentsRegistration} = 'none';
    }

    my $useHttp = $instconfig->getValue('UseHttp');
    my $sso_cert = $instconfig->getValue('SSOCertificate');
    if (defined $useHttp){
        $config->setValue('UseHttp', $useHttp);
    }
    if (defined $sso_cert){
        $config->setValue('SSOCertificate', $sso_cert);
    }

    $config->setValue('ComponentsRegistration', $paramHash->{ComponentsRegistration});   
    $config->setValue('Password', $instconfig->getValue('Password'));

    if(defined $instconfig->{params}->{'HostagentPassword'} && !$instconfig->isSkipped('HostagentPassword')){
        $config->setValue('HostagentPassword',$instconfig->getValue('HostagentPassword'));
    } else {
        $config->{params}->{'HostagentPassword'}->{skip} = 1;
    }
    if(defined $paramHash->{SpecificHosts}){
        $config->setValue('SpecificHosts', $paramHash->{SpecificHosts});
    }
    my $skipHostagentCalls = $instconfig->getValue('SkipHostagentCalls');
    if (defined $skipHostagentCalls) {
        $config->setValue('SkipHostagentCalls', $skipHostagentCalls);
    }
    $config->setValue('SkipModifySudoers', $instconfig->getValue('SkipModifySudoers'));

    return $config;
}

sub createRemoteConfigurationBeforeRename{
    my($self, $sharedDir, $sid, $instconfig, $paramHash) = @_;
    my $skippedComponents;
    if($paramHash->{ComponentsRegistration}){
        $skippedComponents = _getSkippedComponentsByScenario(1,$SCENARIO_RENAME,$instconfig->getSystemComponentManager());
    }
    $paramHash->{SkippedComponents} = $skippedComponents;
    my $remoteHostsObjects = defined($instconfig->getRemoteHosts()) ? [ $instconfig->getRemoteHosts() ] : [];
    my $config = $self->createRemoteConfiguration($instconfig, $remoteHostsObjects, $paramHash);
    $config->setValue('SID',$sid);
    $config->setValue('Target',$sharedDir);
    $config->setValue('Password',$instconfig->getValue('srcPasswd'));
    return $config;
}

sub createLocalConfigurationBeforeRename{
    my($self, $instconfig, $paramHash) = @_;
    my $skippedComponents;
    if($paramHash->{ComponentsRegistration}){
	    $skippedComponents = _getSkippedComponentsByScenario(0,$SCENARIO_RENAME,$instconfig->getSystemComponentManager());
    }
    $paramHash->{SkippedComponents} = $skippedComponents;
    my $config = $self->createLocalConfiguration($instconfig, $paramHash, 1); # isBeforeRename=1
    $config->setValue('Password',$instconfig->getValue('srcPasswd'));                    
    return $config;
}

sub createRemoteConfigurationAfterRename{
    my($self, $sharedDir, $sid, $sidadmPassword, $instconfig, $paramHash) = @_;
   
    if ( !$instconfig->isUseSAPHostagent() && $instconfig->shallUpdateRemoteHostsAfterRename() ){
    	$instconfig->getRefreshedRemoteHosts( undef, 1 );
    }
    my $remoteHosts = $instconfig->getRemoteHosts();
    my $skippedComponents;
    if($paramHash->{ComponentsRegistration}){
	    $skippedComponents = _getSkippedComponentsByScenario(1, $SCENARIO_RENAME, $instconfig->getSystemComponentManager());
    }
    my $newSid = undef;
    if($instconfig->isSIDChanged()){
        $newSid = $instconfig->getValue('newSID');
    }
    my $remoteHostsObjects = defined($remoteHosts) ? [ $remoteHosts ] : [];
    my $config = $self->createRemoteConfiguration($instconfig, $remoteHostsObjects, $paramHash, $newSid);

    $config->setValue('SID',$sid);
    $config->setValue('Target',$sharedDir);
    $config->setValue('Password',$sidadmPassword);
   
    return $config;
}

sub _setLocalCertificateHostName{
	my ($self, $config, $certificatesHostMapValue, $certificatesHostMapDefaultValue) = @_;

	my $localhost = $config->{localHostname};
	my $localHostCertificate = $certificatesHostMapValue->{$localhost};
	my $defaultLocalHostCertificate = $certificatesHostMapDefaultValue->{$localhost};
	
	if ((not defined $localHostCertificate) and (defined $certificatesHostMapValue)) {
		foreach my $host (keys (%{$certificatesHostMapValue})) {
			if (LCM::HostsParser::IsLocalHost($host)) {
				$localHostCertificate = $certificatesHostMapValue->{$host};

				if (! defined $defaultLocalHostCertificate) {
					$defaultLocalHostCertificate = $certificatesHostMapDefaultValue->{$host};
				}

				last;
			}
		}
	}

	# Don't provide certificate value to executor, if user didn't changed default value.
	# This is more error safe, due to possibility to regenerate certificate with default value which is incorrectly detected.
    if ((defined $localHostCertificate) && ($localHostCertificate ne '') && ($localHostCertificate ne $defaultLocalHostCertificate)) {
        $config->setValue('CertificateHostname',$localHostCertificate);
    }
}

sub _buildSkippedComponentsString{
	 my($skippedComponents) = @_;
	 my $skippedComponentsStr;
	 foreach my $skippedComponent ( @{$skippedComponents} ) {
     my $componentKey = $skippedComponent->getComponentBatchKey();
     if ( defined $componentKey) {
         if(defined $skippedComponentsStr){
            $skippedComponentsStr = $skippedComponentsStr.',';
        }
        $skippedComponentsStr = $skippedComponentsStr. $componentKey;
     }           
    }
    return $skippedComponentsStr;
}

sub _getSkippedComponentsByScenario{
	my($isRemote,$scenario,$systemComponentManager) = @_;
	my $installedComponents = $systemComponentManager->getAllComponents();
    my $componentRegistrationManager; 
    if($isRemote){
    	$componentRegistrationManager = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::RemoteComponentsManager(undef,$installedComponents,$scenario);
    } else {
        $componentRegistrationManager = new LCM::Configuration::Hosts::UpdateHosts::ComponentsRegistration::LocalComponentsManager(undef,$installedComponents,$scenario);
    }
    if(defined $componentRegistrationManager){
        $componentRegistrationManager->detectComponents();
        my $skippedComponents = $componentRegistrationManager->getSkippedComponents();
        return $skippedComponents;
    }
    return undef;
}

sub _setLocalHostname{
	my ($srcConfiguration,$targetConfiguration) = @_;
	my $localhost = hostname();
	if($targetConfiguration->can("getLocalHanaHost")){
		$srcConfiguration->{localHostname} = $targetConfiguration->getLocalHanaHost();
	} else{
		$srcConfiguration->{localHostname} = $localhost;
	}
}

return 1;
