package LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfigurationWithSHA;

use base qw ( LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration);
use LCM::Configuration::GenericStackAny qw ( $ini_section_general  );
use strict;

sub new {
    my $self = shift->SUPER::new (@_);
    return $self;
}

sub getUpdateHostParameters{
    my($self,$order) = @_;
    my $params = $self->SUPER::getUpdateHostParameters($order);
    $params->{'HostagentPassword'} = $self->getParamHostagentPassword($order++, $ini_section_general);
    return $params;   
}

# No checks needed, this configuration is used only internally
sub checkHostagentPassword {
    return 1;
}

# No checks needed, this configuration is used only internally
sub checkPassword {
    return 1;
}

sub setRemoteExecution{
    my ($self, $value) = @_;
    my $rc = $self->SUPER::setRemoteExecution($value);
    if($rc){
        $self->{params}->{HostagentPassword}->{type} = 'passwd';
        $self->setSkip('HostagentUserName', 0);
        $self->setSkip('HostagentPassword', 0);
    }
    return $rc;
}
return 1;