package LCM::Configuration::PrintDetectedComponentsConfiguration;

use strict;
use warnings;
use parent qw(LCM::Configuration::GenericStackConfiguration SDB::Install::Configuration::AnyConfig);
use LCM::Configuration::ParametersCreator;
use LCM::Configuration::GenericStackAny qw($ini_section_general);

sub new {
    my ($class, $options, $configFile) = @_;
    my $self = $class->SUPER::new($options, $configFile);

    $self->defineParams();
    $self->addListeners();

    return $self;
}

sub getAction {
    return 'print_detected_components';
}

sub defineParams {
    my ($self) = @_;
    my $order = scalar keys %{ $self->{params} };

    $self->{params} = {
        'DvdPath' => GetParamDvdPath($order++, $ini_section_general),
        'ComponentDirs' => GetParamComponentDirs($order++, $ini_section_general),
        'ComponentFsRoot' => GetParamComponentFsRoot($order++, $ini_section_general, 1),
    };
}

sub handleSelectionOfServerComponent {
    return;
}

1;