package LCM::Configuration::SelectedSystemValuesBuilder;

use SDB::Install::Globals;
use constant UPDATE => ' (update)';
use constant RESUME_PENDING => ' (resume pending installation)';

sub new{
    my($class,$config) = @_;
    my $self = bless{{},$class};
    $self->{config} = $config;
    return $self;
}

sub getValidValues{
    my $self = shift;
    $self->{_validValues} = $self->{_validValues} // [];
    return $self->{_validValues} ;
}

sub getUiValues{
    my $self = shift;
    $self->{_uiValues} = $self->{_uiValues} // [];
    return $self->{_uiValues} ;
}

sub addValidValue{
    my ($self,$value) = @_;
    push(@{$self->getValidValues()}, $value );
}

sub addUiValue{
    my ($self,$value) = @_;
    push(@{$self->getUiValues()}, $value );
}

sub addInstalledSystems{
    my $self = shift;
    my $collection = $self->getConfiguration()->getSystemCollection();
    my @installedSIDs =$collection->getInstalledSystems();

    foreach my $sid (@installedSIDs) {
        $self->addValidValue($sid . UPDATE );
        my $uiValue = "Update ".SDB::Install::Globals::getFlavourProductName($collection->getInstalledSystemFlavour($sid));
        $uiValue .= ' version '.$collection->getSystemVersion($sid) ;
        $uiValue .= $collection->getInstalledSystemInfo($sid). "\n";
        $self->addUiValue($uiValue);
    }
}

sub addPendingInstallations{
    my $self = shift;
    my $systemsCollection = $self->getConfiguration()->getSystemCollection();
    my @pendingInstallations = $systemsCollection->getPendingInstallations();

    foreach my $sid (@pendingInstallations) {
       $self->addValidValue( $sid. RESUME_PENDING );
       my $pendingSapsys = $systemsCollection->getPendingInstallSystem($sid);
       my $uiValue = "Install ".SDB::Install::Globals::getFlavourProductName($pendingSapsys->getHANAFlavour());
       $uiValue .= ' version '.$systemsCollection->getSystemVersion($sid);
       $uiValue .= $self->getConfiguration()->getSystemCollection()->getPendingInstallSystemInfo($sid). "\n";
       $self->addUiValue($uiValue);
   }
}

sub addInstall{
    my $self = shift;
    $self->addValidValue( "install"  );
    $self->addUiValue( "Install new system");
}

sub addExit{
    my $self = shift;
    my $exitValue = $self->getConfiguration()->getDefault('SelectedSystem');
    $self->addValidValue($exitValue );
    $self->addUiValue( '' );
}

sub addLSSPendingInstallations{
    my $self = shift;
    my @pendingLSSInstSids = $self->getConfiguration()->getSystemCollection()->getLSSPendingInstallations();
    foreach my $sid(@pendingLSSInstSids){
        $self->addValidValue( $sid .RESUME_PENDING );
        $self->addUiValue( $self->getConfiguration()->getSystemCollection()->getPendingLSSInstallationInfo($sid) . "\n");
    }
}

sub getConfiguration{
    my $self = shift;
    return $self->{config};
}

sub initDefaultSystems {
    ...
}

1;
