package LCM::Configuration::ValueChangeListeners::AddHostAddHostsListener;

use LCM::HostsParser qw ( ExtractLocalAndRemoteHosts );

use SDB::Install::Configuration qw ( $bool_true_pattern $bool_false_pattern );
use SDB::Install::Globals qw ($gHostRoleAcceleratorStandby $gHostRoleAcceleratorWorker );

sub new {
	my ($class, ) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ( $self, $value, $config) = @_;

	$config->initRecommendationTexts();

	if ( $config->isUseSAPHostagent() ) {
		$self->_recomputeSHAParameters($value, $config);
	}
	$config->fillInternalNetworkAndListenInterfaceValidValues();
	$self->_handleHostagentPasswordType($value, $config);
	$config->fillCertificatesHostmapDataForLocalHost();
	$self->recomputeRequiredAcceleratorParameters( $config );
	return 1;
}

sub _handleHostagentPasswordType {
	my ( $self, $value, $config) = @_;

	my ( $localHostInputString, $remoteHostsInputString ) = ExtractLocalAndRemoteHosts($value, $config);
	my $isLocalHostSelected = defined $localHostInputString;
}

sub _recomputeSHAParameters {
	my ( $self, $value, $config) = @_;

	my ( $localHostInputString, $remoteHostsInputString ) = ExtractLocalAndRemoteHosts($value, $config);
	my $isOnlyLocalHostSelected = ! defined $remoteHostsInputString; 
	my $isSHAInstalledOnLocalHost = $config->isHostagentInstalled();
	my $installSHABatchValue = $config->getBatchValue("InstallHostagent");

	if ( $isOnlyLocalHostSelected ) {
		if ($installSHABatchValue =~ m/$bool_false_pattern/ || $isSHAInstalledOnLocalHost) {
			$config->setSkip('HostagentPassword', 1);
			$config->setSkip('InitialHostagentPassword', 1);
		}
		return;
	}

	my $isLocalHostSelected = defined $localHostInputString;
	if ( !$isLocalHostSelected ) {
		return;
	}

	if ( !$isSHAInstalledOnLocalHost && $installSHABatchValue =~ m/$bool_true_pattern/ ) {
		my $localHostConfiguration = $config->{localHostConfiguration};
		$localHostConfiguration->setSkip("InstallHostagent", 0);
		$localHostConfiguration->setValue("InstallHostagent", 1);
	}
}

sub recomputeRequiredAcceleratorParameters {
    my ( $self, $config ) = @_;

	my $shouldSkipAcceleratorParameters = 1;
	if ( $config->getValue('AddHosts') =~ /role=($gHostRoleAcceleratorStandby|$gHostRoleAcceleratorWorker)/ ) {
		$shouldSkipAcceleratorParameters = 0;
    }
    
    $config->setSkip('SystemUser', $shouldSkipAcceleratorParameters);
	$config->setSkip('SQLSysPasswd', $shouldSkipAcceleratorParameters);
	$config->setSkip('AcceleratorUser', $shouldSkipAcceleratorParameters);
	$config->setSkip('AcceleratorPassword', $shouldSkipAcceleratorParameters);
}

1;
