package LCM::Configuration::ValueChangeListeners::AddHostRemoteExecutionListener;
use LCM::HostsUtility qw (IsHostPartOfSystem);

sub new {
	my ($class, ) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;
	
	my $skipRootCredentials = 0;
	if ( $value eq 'saphostagent' ) {
		$skipRootCredentials = 1;
        $config->setSkip('InstallSSHKey', 1);	
		$config->setSkip('HostagentPassword', 0);
	}
	
	$self->skipRootCredentials( $config, $skipRootCredentials );

	return 1;
}

sub skipRootCredentials {
	my ( $self, $config, $flag ) = @_;
    $config->setSkip('RootUser', $flag);
    # RootPassword will be unskipped in tryRemoteKeyAuthorization if needed
    $config->setSkip('RootPassword', 1);
}

1;
