package LCM::Configuration::ValueChangeListeners::AddHosts::XSUserIsolationListener;

use strict;
use LCM::HostsParser;
use SDB::Install::Configuration qw($bool_true_pattern);
use parent 'LCM::Configuration::ValueChangeListeners::XSUserIsolationBase';
use SDB::Install::Globals qw($gHostRoleStandby $gHostRoleWorker $gHostRoleXS2Standby $gHostRoleXS2Worker);

# Override
sub _getHostsList {
    my ($self, $configuration) = @_;
    my $hostsParser = new LCM::HostsParser();
    my $addHostsCsv = $configuration->getValue('AddHosts');
    my $isAutoAddingXsRoles = !$configuration->isSkipped('AutoAddXS2Roles') && $configuration->getValue('AutoAddXS2Roles');
    my $result = [];

    $hostsParser->parse($addHostsCsv);

    my $hosts = $hostsParser->getHosts() || [];

    for my $host (@{$hosts}){
        my $roles = $hostsParser->getRoles($host);
        my $hasXsRole = grep { $_ eq $gHostRoleXS2Standby || $_ eq $gHostRoleXS2Worker } @{$roles};
        my $hasDbRole = grep { $_ eq $gHostRoleStandby || $_ eq $gHostRoleWorker } @{$roles};
        my $isAdditionalXsHost = $hasXsRole || ($hasDbRole && $isAutoAddingXsRoles);

        push(@{$result}, $host) if($isAdditionalXsHost);
    }
    return $result;
}

1;