package LCM::Configuration::ValueChangeListeners::Cockpit::CockpitSelectionListener;

use strict;
use SDB::Install::Globals qw($gProductNameCockpit
                             $gProductNamePlatform
                             $gKeynameCockpitStack
                             $gShortProductNameCockpit
                             $gOptionOptimizedExecutionMode);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, undef, $configuration) = @_;
    my $mcm = $configuration->getComponentManager();
    if (!$mcm->isComponentSelected($gKeynameCockpitStack)) {
        $configuration->setErrorMessage("To install $gProductNameCockpit on $gProductNamePlatform you need to select the $gShortProductNameCockpit stack component.");
        return 0;
    }

    $configuration->setDefault('ExecutionMode', $gOptionOptimizedExecutionMode);
    return 1;
}

1;