package LCM::Configuration::ValueChangeListeners::Cockpit::CockpitTenantListener;

use strict;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $tenantName, $configuration) = @_;
    my $instance = $configuration->getOwnInstance();

    if($tenantName eq 'SYSTEMDB') {
        $configuration->setErrorMessage("SYSTEMDB is not allowed for Cockpit tenant database name");
        return 0;
    }

    if ($instance->isIsolatedMultiDb()) {
        $configuration->setErrorMessage("Multidb is configured in high isolation mode. Please create the tenant database manually and then repeat the installation");
        $configuration->setNoRetry('CockpitTenant', 1);
        return 0;
    }

    $configuration->setSkip('CockpitTenantUserPassword', 0);
    if ($instance->tenantExists($tenantName)) {
        $configuration->setSkip('CockpitTenantUser', 0);
    } else {
        $configuration->setType('CockpitTenantUserPassword', 'initial_passwd');
    }

    return 1;
}

1;