package LCM::Configuration::ValueChangeListeners::Cockpit::DetectXSSpaceListener;

use strict;
use SDB::Install::Globals qw($gProductNameCockpit
                             $gEvenShorterProductNameXSA
                             $gShortProductNameCockpit);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, undef, $configuration) = @_;

    if (!$configuration->isCockpitOnPlatformAction()) {
        return 1;
    }
    my $xsApp = $self->_determineCockpitApp($configuration);
    my $isInstallingCockpit = $configuration->isUpdate() && !$configuration->isCockpitStackUpdate();

    if ($xsApp && !$isInstallingCockpit) {
        my $spaceGUID = $xsApp->getRegistryID();
        $configuration->getMsgLst()->addMessage("The $gProductNameCockpit application was detected in space with GUID '$spaceGUID'.");
        $configuration->setSkip('CockpitXSSpace', 1);
        $configuration->setValue('CockpitSpaceGUID', $spaceGUID);
    } else {
        $configuration->setValue('CockpitSpaceGUID', undef);
    }

    return 1;
}

sub _determineCockpitApp {
    my ($self, $config) = @_;
    my $scm = $config->getSystemComponentManager();
    my $allXsApps = $scm->getXSAppsManager()->getAllXSApps();
    my @cockpitApps = grep { $_->isCockpit() } @{$allXsApps};

    if (@cockpitApps != 1) { # Either 0 or > 1 => detection is unsuccessful
        my $reason = !@cockpitApps ?
                     "The $gShortProductNameCockpit application was not detected on the system." :
                     "The $gShortProductNameCockpit appliaction was detected in multiple spaces.";
        $config->getMsgLst()->addWarning("Failed to detect the $gEvenShorterProductNameXSA space for $gProductNameCockpit: $reason");
        return undef;
    }

    return $cockpitApps[0];
}

1;