package LCM::Configuration::ValueChangeListeners::ComponentListener;

use strict;
use base qw(LCM::Configuration::ValueChangeListeners::ComponentLocationListener);

sub new {
    my ($class, $componentScanner, $parametarName) = @_;
    my $self = $class->SUPER::new(@_);
    $self->{componentScanner} = $componentScanner;
    $self->{parametarName} = $parametarName;
    return $self;
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;

    if ( !$self->SUPER::onValueChange($value, $instconfig)) {
        return 0;
    }

    my $mediumCmpMgr = $instconfig->getComponentManager();

    my $param = $instconfig->{params}->{$self->{parametarName}};
    my $rc = $self->{componentScanner}->scan($self->{parametarName},$value);
    if($mediumCmpMgr->areDetectedOnlyOtherPlatformComponents()){
        $instconfig->appendErrorMessage($mediumCmpMgr->getErrorString());
        return undef;
    }

    if ($rc){
        $instconfig->appendErrorMessage ("$param->{str} '$value' is invalid", $self->{componentScanner}->getErrMsgLst ());
        return undef;
    }

	if ($instconfig->can('initializeSelectedComponents')
		&& !$instconfig->initializeSelectedComponents()) {
		$instconfig->setNoRetry($self->{parametarName},1);
		return undef;
	}

    # If there are detected components, ComponentFsRoot should not be interactive
    $instconfig->setInteractive('ComponentFsRoot', 0);

    return 1;
}

1;