package LCM::Configuration::ValueChangeListeners::ConfigureInternalNetwork::ListenInterfaceRestartListener;
use parent qw(LCM::Configuration::ValueChangeListeners::ConfigureInternalNetwork::BaseRestartListener);
use strict;
use warnings;

sub onValueChange {
    my ($self, $value, $config) = @_;

    $config->clearParameterWarnings('ListenInterface');
    my $instance = $config->getOwnInstance();
	my $currentInternalNetwork = $instance->getInternalNetworkPrefix();

	if ($value eq 'local' && defined $currentInternalNetwork) {
		$config->addParameterWarning('ListenInterface', $self->getRestartRequiredMessage());
	}
	return 1;
}

1;
