package LCM::Configuration::ValueChangeListeners::DownloadComponents::AuthorizationProxyConnectionListener;

use strict;
use LCM::FileUtils qw(MyRealPath);
use SDB::Install::System qw(loadSSLRequiringPackage);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;

    return $self->_hasOutboundConnectivity($configuration, $value) ? 1 : undef;
}

sub _hasOutboundConnectivity {
    my ($self, $configuration, $proxyPassword) = @_;
    my $webServiceProxyURL = $configuration->getValue('WebServiceProxyURL');
    $webServiceProxyURL =~ s/\/$//;
    my $indexPageURL = sprintf('%s/%s', $webServiceProxyURL, 'index.html');
    my ($webServiceHost) = $webServiceProxyURL =~ m!^https?://([^/:]+)/!;
    my $caPath = MyRealPath($configuration->getValue('CAPath'));
    my $response = undef; # undef by default
    my $proxyHost = $configuration->getValue('ProxyHost');
    my $proxyPort = $configuration->getValue('ProxyPort');
    my $proxyUser = $configuration->getValue('ProxyUser');

    return undef if (!loadSSLRequiringPackage ('LWP::Protocol::https', $configuration->getMsgLst (), $configuration->getErrMsgLst ()));
    require LCM::Utils::TCPUserAgent;

    eval {
        local $SIG{__DIE__} = 'DEFAULT';
        my $userAgent = new LCM::Utils::TCPUserAgent($caPath);

        $userAgent->setProxyHost($proxyHost);
        $userAgent->setProxyPort($proxyPort);
        $userAgent->setProxyUser($proxyUser);
        $userAgent->setProxyPassword($proxyPassword);

        $response = $userAgent->get($indexPageURL);
    };
    my $isTLSv1_2Error = defined($response) && $response->code() == 500 && ($response->decoded_content() =~ /error:14077410:SSL/);

    if($@ || (!$isTLSv1_2Error && !$response->is_success())){
        my $suffix = defined($@) && length($@) ? $@ : $response->status_line();
        $configuration->getErrMsgLst()->addError(sprintf('Cannot establish connection to host \'%s\': %s', $webServiceHost, $suffix));
        return undef;
    }
    return 1;
}

1;