package LCM::Configuration::ValueChangeListeners::ExtractComponents::UploadArchivesListener;

use strict;
use SDB::Install::Configuration qw($bool_false_pattern);

sub new {
    my $class = shift();
    return bless({}, $class);
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $shallSkipSelectedArchives = ($value =~ $bool_false_pattern) ? 1 : 0;
    my $shallHideComponentArchivesPath = ($value =~ $bool_false_pattern) ? 0 : 1;

    $configuration->setSkip('SelectedArchives', $shallSkipSelectedArchives);
    $configuration->setHidden('ComponentArchivesPath', $shallHideComponentArchivesPath);

    return 1;
}

1;