package LCM::Configuration::ValueChangeListeners::InstallUpdate::RecomputeXs2SpaceIsolationParameters;

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new { return bless({}, shift()); }

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $isUsingSAPSpaceIsolation = $configuration->hasValue('XSSAPSpaceIsolation') ? $configuration->getValue('XSSAPSpaceIsolation') : $configuration->getDefault('XSSAPSpaceIsolation');
	my $shouldSkipSAP = ($isUsingSAPSpaceIsolation =~ /$bool_true_pattern/) ? 0 : 1;
	my $shouldSkipProd = ($value =~ /$bool_true_pattern/) ? 0 : 1;
	$configuration->setSkip('XSSpaceUserIdProd', $shouldSkipProd);
	$configuration->setSkip('XSSpaceUserIdSAP', $shouldSkipSAP);
	return 1;
}

1;
