package LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationCLIListener;

use strict;
use warnings;
use parent 'LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationListenerBase';
use SDB::Install::Tools;
use SDB::Install::Globals qw($gFailedSignatureVerificationMessage);
use LCM::SAPDSigner;


sub handleSapdsignerLogging {
    my ($self, $sapdsigner, $instconfig) = @_;
    my $isUpdateBootstrap = LCM::Installer->new()->isInstalled() && $instconfig->getAction() eq 'update';
    if ($instconfig->isPendingInstallation() || $isUpdateBootstrap ) {
        $self->SUPER::handleSapdsignerLogging($sapdsigner, $instconfig);
    } else {
# Force SAPDSigner to append error messages to the MsgLst instead of ErrMsgLst
# so that if the user selects 'n' on askConfirmation, the errors don't appear
# on the console after the confirmation
        my $configMsgLst = $instconfig->getMsgLst();
        $sapdsigner->setMsgLstContext([ $configMsgLst, $configMsgLst ]);
    }
}

# Override
sub onErrorMessage {
    my ($self, $msg, $configuration) = @_;
    $configuration->getMsgLst()->addProgressMessage($msg);
}

sub handleVerificationFailure {
    my ($self, $instconfig) = @_;
    return SDB::Install::Tools::askConfirmation($gFailedSignatureVerificationMessage.' Do you want to continue?', 'n');
}

1;
