package LCM::Configuration::ValueChangeListeners::InstallUpdate::XsTenantInstallationListenerBase;

use strict;
use SDB::Install::Globals qw($gKeynameXS2);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, undef, $instconfig) = @_;
    return 1 if !$instconfig->isComponentSelected($gKeynameXS2);

    my $parameter = $self->getRelevantParameterID($instconfig);
    my $shouldEnableParameter = $self->shouldEnableRelevantParameters($instconfig);
    $instconfig->setSkip($parameter, $shouldEnableParameter ? 0 : 1);
    if ($parameter eq 'InstallXSInDefaultTenant') {
        $instconfig->setDefault('InstallXSInDefaultTenant', $shouldEnableParameter ? 1 : 0);
    }

    return 1;
}

sub getRelevantParameterID {
    my ($self, $instconfig) = @_;
    return 'XSTenantDatabaseName';
}

sub shouldEnableRelevantParameters {
    my ($self, $instconfig) = @_;
    my $xsComponent = $instconfig->getComponentManager()->getComponentByKeyName($gKeynameXS2);
    return $xsComponent->isFeatureSupported('tenant_install') ? 1 : 0;
}

1;
