package LCM::Configuration::ValueChangeListeners::RemoveHostRemoveHostsListener;

use strict;
use SDB::Install::Globals qw($gHostRoleXS2Standby $gHostRoleXS2Worker $gHostRoleWorker $gHostRoleStandby);

sub new {
	bless({}, shift());
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;
	my $scenarioDetector = $instconfig->getRemoveHostsDetector();
	my $skipRemoteAuthentication = $scenarioDetector->userInputContainsRemoteHosts($value) ? 0 : 1;

	if($instconfig->isUseSAPHostagent()){
		$instconfig->setSkip('RootPassword', 1);
		$instconfig->setSkip('RootUser', 1);
		$instconfig->setSkip('HostagentPassword', $skipRemoteAuthentication);
	} else {
#RootPassword will be unskipped only if needed (sub tryRemoteKeyAuthorization)
		$instconfig->setSkip('RootUser', $skipRemoteAuthentication);
		$instconfig->setSkip('HostagentPassword', 1);
	}

	$instconfig->setSkip('KeepXsUsers', $self->_shallSkipKeepXsUsersParam($scenarioDetector, $value));
	return 1;
}

sub _shallSkipKeepXsUsersParam {
	my ($self, $detector, $removeHostsUserInput) = @_;
	my $selecedHosts = $detector->getHostsFromUserInput($removeHostsUserInput) || [];
	my $isRemovingXsHost = grep { $detector->isHostInRole($_, $gHostRoleXS2Standby) || $detector->isHostInRole($_, $gHostRoleXS2Worker) } @{$selecedHosts};
	my $isRemovingDbHost = grep { $detector->isHostInRole($_, $gHostRoleStandby)    || $detector->isHostInRole($_, $gHostRoleWorker) } @{$selecedHosts};

	return ($isRemovingXsHost || $isRemovingDbHost) ? 0 : 1;
}

1;