package LCM::Configuration::ValueChangeListeners::RemoveHostRoles::AcceleratorCredentialsListener;
use strict;

sub new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub onMapValueChange{
    my ($self, $valKey, $value, $configuration) = @_;

    my $shouldSkip = 1;
    my $params = $configuration->{params}->{RemoveRoles}->{value};
    for my $host (keys %$params) {
        if ($params->{$host} =~ /ets_/) {
            $shouldSkip = 0;
            last;
        }
    }
    $configuration->setSkip('AcceleratorUser', $shouldSkip);
    $configuration->setSkip('AcceleratorPassword', $shouldSkip);
    $configuration->setSkip('SystemUser', $shouldSkip);
    $configuration->setSkip('SQLSysPasswd', $shouldSkip);
    return 1;
}

1;