package LCM::Configuration::ValueChangeListeners::Rename::TargetSIDListener;

use strict;
use File::Spec;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ( $self, $value, $instconfig) = @_;
    my $sourcePassword = $instconfig->getValue('srcPasswd') || '';

    if ($value && ($value ne $instconfig->getSID())) {
        $self->_configureKeepUserParams($instconfig);
        $instconfig->setMandatory('Password', 1);
        $instconfig->setDefault('HomeDir',"/usr/sap/$value/home");
    } elsif (length($sourcePassword) > 0) {
        $instconfig->setValue('Password', $sourcePassword);
        $instconfig->{params}->{Password}->{set_interactive} = 0;
    }
    $self->_setDefaultXsEaDataPath($value, $instconfig);
    return 1;
}

sub _configureKeepUserParams {
    my ($self, $instconfig) = @_;
    return undef if($instconfig->isRegisterScenario());

    my @paramIds = ('KeepUser', 'KeepUserHomeDir');
    for my $paramId (@paramIds) {
        $instconfig->setInteractive($paramId, 1);
        $instconfig->setDefault($paramId, 0);
        $instconfig->setHidden($paramId, 0);
        $instconfig->setSkip($paramId, 0);
    }
}

sub _setDefaultXsEaDataPath {
    my ($self, $newSID, $instconfig) = @_;
    my $oldSID = $instconfig->getSID();
    my $trexInstance = $instconfig->getOwnInstance();
    my $oldDataPath = $trexInstance->getXSEADataPath();

    return if(! defined($oldDataPath));

    my $sapSys = $instconfig->getSAPSystem();
    my $userConfig = $sapSys->getUserConfig() || {};
    my $oldTarget = $userConfig->{installation_path};
    my $newTarget = $instconfig->hasValue('Target') ? $instconfig->getValue('Target') : $instconfig->getDefault('Target');

    if(defined($oldTarget) && defined($newTarget)){
        $oldTarget = File::Spec->canonpath($oldTarget);
        $newTarget = File::Spec->canonpath($newTarget);
        $oldDataPath =~ s/^\Q$oldTarget\E/$newTarget/;
    }
    $oldDataPath =~ s/\Q$oldSID\E/$newSID/g;

    $instconfig->setDefault('XsEaDataPath', $oldDataPath);
}

1;