package LCM::Configuration::ValueChangeListeners::SHAVersionListener;
use strict;

use SAPDB::Install::Hostname;
use SDB::Install::Configuration qw($bool_true_pattern);
use SDB::Install::Saphostagent qw(getSHAVersion);
use SDB::Install::System qw (isSidadmin);

sub new {
	my ($class, ) = @_;
	my $self = {};
	bless $self, $class;
	return $self;
}

sub onValueChange {
	my ( $self, $value, $config) = @_;
	return $self->_isPossibleSHAUpdate($config);
}

sub _isPossibleSHAUpdate {
	my ($self, $config) = @_;
	my $isRemoteExecutionSHA = $config->isUseSAPHostagent();

	if (!$isRemoteExecutionSHA) {
		return 1;
	}

	if (! $config->willInstallOrUpdateSHA()) {
		return 1;
	}

	my $incompatibleSHAVersionString = '7.21.10';
	my $incompatibleSHAVersion = new SDB::Install::Version(split('\.', $incompatibleSHAVersionString));
	my $remoteHostsObjects = $config->getRemoteHostsObjects();
	my $remoteHostnames = [];

	if(defined($remoteHostsObjects) && scalar(@{$remoteHostsObjects}) > 0){
		for my $remoteHosts (@{$remoteHostsObjects}){
			push(@{$remoteHostnames}, @{$remoteHosts->getHostNames()});
		}
	}

	my @affectedHosts = ();
	for my $hostname (@{$remoteHostnames}) {
		last if (!exists($config->{remoteSaphostagents}));

		my $remoteSHAVersionString = $config->{remoteSaphostagents}->{$hostname}->{version};

		next if(!defined $remoteSHAVersionString);

		my $remoteSHAVersion = new SDB::Install::Version(split('\.', $remoteSHAVersionString));
		if (!$remoteSHAVersion->isNewerThan($incompatibleSHAVersion)) {
			push(@affectedHosts, $hostname);
		}
	}

	my $sid = $config->getSID();
	my $isSidAdmUserExecution = (isSidadmin($sid)) ? 1 : 0;

	if ($isSidAdmUserExecution) {
		$config->{localSHAVersionString} //= getSHAVersion($config);
		if (defined $config->{localSHAVersionString}) {
			my $localSHAVersion = new SDB::Install::Version(split('\.', $config->{localSHAVersionString}));

			if (!$localSHAVersion->isNewerThan($incompatibleSHAVersion)) {
				push(@affectedHosts, hostname());
			}
		}
	}

	if (!scalar(@affectedHosts)) {
		return 1;
	}

	my $action = $config->getProductName();
	my $affectedHostsStr = join(', ', @affectedHosts);
	my $isWebUI = ($config->isa('LCM::Configuration::Web::UpdateComponentsConfiguration') || $config->isa('LCM::Configuration::Web::UpdateSystemConfiguration')) ? 1 : 0;

	my $errorMsg = "$action cannot be executed with the current SAP Host Agent version";
	$errorMsg .= "via the Web UI" if ($isWebUI);
	$errorMsg .= ($isSidAdmUserExecution) ? (($isWebUI) ? ', ' : ' ') . 'as ' . lc($sid) . 'adm user' : '';
	$errorMsg .= ($isRemoteExecutionSHA) ? (($isWebUI || $isSidAdmUserExecution) ? ', or ' : ' ') . 'with remote execution via SAP Host Agent' : '';
	$errorMsg .= '. Do one of the following:';
	$errorMsg .= "\n - Start hdblcm or hdblcmgui as root user. Use either remote execution via SSH or execute the operation decentralized using scope \'instance\'.";
	$errorMsg .= "\n - Upgrade SAP Host Agent manually on hosts $affectedHostsStr to version 7.21.11 or newer and repeat the operation with hdblcm.";

	$config->setErrorMessage($errorMsg);
	return undef;
}

1;
