package LCM::Configuration::ValueChangeListeners::SLD::SLDConnectionListener;

use strict;

sub new {
	return bless({}, shift());
}

sub onValueChange {
	my ($self, $value, $config) = @_;

	$config->clearParameterWarnings('UseHTTPS');
	my $warnings = $config->checkSLDConnection();
	for my $warning (@{$warnings}) {
		$config->addParameterWarning('UseHTTPS', $warning);
	}

	return 1;
}

1;
