package LCM::Configuration::ValueChangeListeners::SignatureVerificationListenerFactory;

use strict;
use warnings;
use LCM::App::ApplicationContext;
use LCM::Slpp::Update::Listeners::SignatureVerificationSLPListener;
use LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationCLIListener;
use LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationBatchListener;

sub getSignatureVerificationListener {
	my $applicationMode = LCM::App::ApplicationContext::getInstance()->getMode();
	if ($applicationMode eq 'SLP') {
		return LCM::Slpp::Update::Listeners::SignatureVerificationSLPListener->new();
	} elsif ($applicationMode eq 'CLI') {
		return LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationCLIListener->new();
	} elsif ($applicationMode eq 'Batch') {
		return LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationBatchListener->new();
	} elsif ($applicationMode eq 'GUI') {
		require LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationGUIListener; 
		return  LCM::Configuration::ValueChangeListeners::InstallUpdate::SignatureVerificationGUIListener->new();
	}

	die('Zoinks! Something went terribly wrong...');
}

1;
