package LCM::Configuration::ValueChangeListeners::Update::ConsoleWriterSIDListener;

use LCM::PersistencyUtils qw (existsHdblcmPendingUpdate);

sub new {
	my ($class) = @_;

	my $self = {};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	my $applicationContext = LCM::App::ApplicationContext::getInstance();
	my $mode = $applicationContext->getMode();
	if ($mode ne "CLI" && $mode ne "Batch") {
	    return 1;
	}
	my $cannotBeSelectedMessage = $instconfig->getCannotBeSelectedMessage();
	if (defined $cannotBeSelectedMessage && $cannotBeSelectedMessage ne "" && !existsHdblcmPendingUpdate($value)) {
	    print $cannotBeSelectedMessage;
	}

    return 1;
}

1;
