package LCM::Configuration::ValueChangeListeners::Update::EnableTenantSystemUserCredentials;

use strict;
use warnings;
use SDB::Install::Globals qw ($gKeynameXS2);

sub new {
    my ($class,$param) = @_;
    my $self = {};
    bless $self, $class;
    $self->{_caller}=$param;
    return $self;
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    return 1 if(!($configuration->isConvertToMultiDbRequired() && $self->_isXSSelected($configuration)));
    if($self->{_caller} eq 'SystemUser'){
       $configuration->setHidden('TenantUser', 1);
       $configuration->setSkip('TenantUser', 0);
       return 0 if(!$configuration->setValue('TenantUser',$value));
    }
    elsif($self->{_caller} eq 'SQLSysPasswd'){
       $configuration->setHidden('SQLTenantUserPassword', 1);
       $configuration->setSkip('SQLTenantUserPassword', 0);
       return 0 if(!$configuration->setValue('SQLTenantUserPassword',$value));
    }
    else{
       return 0;
    }
    return 1;
}

sub _isXSSelected{
    my ($self,$configuration) = @_;
    my $componentManager = $configuration->getComponentManager();
    my $xs2Component = $componentManager->getComponentByKeyName($gKeynameXS2);
    return 1 if(defined $xs2Component && $xs2Component->isComponentSelected());
    return 0;
}

1;