package LCM::Configuration::ValueChangeListeners::Update::InstallHostagentListener;

use strict;
use SDB::Install::Configuration qw ( $bool_true_pattern );
use SDB::Install::Saphostagent qw (getSaphostexecPath);

sub new { bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    my $mcm = $instconfig->getComponentManager();

    return 1 if ((defined $mcm) && (!$mcm->isHDBServerComponentSelected()));

    my $shallInstallSHA = ($value =~ /$bool_true_pattern/);
# In SLP execution mode it's possible to enter this listener at the end of execution
# So this is why we need to check the status of AddHosts parameter
    my $isAddingHosts = (! $instconfig->isSkipped('AddHosts')) && (length($instconfig->getValue('AddHosts')) > 0);
    my $isAddingHostsViaSHA = $isAddingHosts && $instconfig->isUseSAPHostagent();

    if (! $shallInstallSHA && ! $isAddingHostsViaSHA) {
        $instconfig->setSkip('HostagentPassword', 1);
        $instconfig->setSkip('SkipHostagentPw', 1);
        $instconfig->setSkip('HostagentUserName', 1);
        return 1;
    }

    my $saphostexecPath = getSaphostexecPath($instconfig);
    my $skipHostagentPassword = ($isAddingHostsViaSHA || !defined($saphostexecPath)) ? 0 : 1;

    $instconfig->setSkip('HostagentPassword', $skipHostagentPassword);
    if (exists($instconfig->{params}->{HostagentPassword}) && $isAddingHostsViaSHA ) {
        $instconfig->{params}->{HostagentPassword}->{type} = 'passwd';
    }
    return 1;
}

1;
