package LCM::Configuration::ValueChangeListeners::Update::UpdateExecutionModeListener;

use strict;

use SDB::Install::Globals qw($gOptionOptimizedExecutionMode $gOptionStandardExecutionMode);
use LCM::Component qw(ONLINE_PHASE SYSTEM_ONLINE_PHASE);

sub new {
	my ($class) = @_;

	my $self = {};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ($self, $value, $config) = @_;

    if ($value eq $gOptionStandardExecutionMode && $config->isConvertToMultiDbRequired()) {
	    my $errorMsg = "Value \"$gOptionStandardExecutionMode\" is invalid. Conversion to multitenant database containers is only possible in $gOptionOptimizedExecutionMode update execution mode.";
        $config->setErrorMessage($errorMsg);
        return 0;
	}
	my $isDistributed = $config->isDistributedSystem();
	if ($value eq $gOptionStandardExecutionMode || $config->isPrepareUpdate() || !$isDistributed) {
		return 1;
	}

	my $isOnlinePhaseSupported = 0;
	my $isSystemOnlinePhaseSupported = 0;
	my $isSystemRestartRequired = 0;
	my $isInstanceRestartRequired = 0;
	my $mcm = $config->getMediumComponentManager();
	my $selectedComponents = $mcm->getSelectedComponents();

	for my $component (@{$selectedComponents}) {
		if (!$component->supportsPhases()) {
			next;
		}

		$isOnlinePhaseSupported |= $component->supportsPhase(ONLINE_PHASE);
        $isSystemOnlinePhaseSupported |= $component->supportsPhase(SYSTEM_ONLINE_PHASE);
		$isSystemRestartRequired |= $component->isSystemRestartRequired();
		$isInstanceRestartRequired |= $component->isInstanceRestartRequired();
	}

	if ($isOnlinePhaseSupported || $isSystemOnlinePhaseSupported || $isSystemRestartRequired || $isInstanceRestartRequired) {
		$config->setSkip('Password', 0);
	}

	return 1;
}

1;
