package LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::ComponentLocationListener';

sub new {
    my $self = shift->SUPER::new(@_);
    my ($scanner, $paramId) = @_;
    $self->setScanner($scanner);
    $self->setParamId($paramId);

    return $self;
}

sub setScanner {
    my ($self, $scanner) = @_;
    $self->{scanner} = $scanner;
}

sub getScanner {
    my ($self) = @_;
    return $self->{scanner};
}

sub setParamId {
    my ($self, $paramId) = @_;
    $self->{paramId} = $paramId;
}

sub getParamId {
    my ($self) = @_;
    return $self->{paramId};
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;
    return 0 if !$self->SUPER::onValueChange($value, $instconfig);

    my $scanner = $self->getScanner();
    my $paramId = $self->getParamId();
    my $paramString = $instconfig->getString($paramId);

    if ($scanner->scan($paramId, $value)) {
        $instconfig->appendErrorMessage ("$paramString '$value' is invalid", $scanner->getErrMsgLst ());
        return undef;
    }

    # If there are detected components, ComponentFsRoot should not be interactive
    $instconfig->setInteractive('ComponentFsRoot', 0);
    return 1;
}

1;