package LCM::Configuration::ValueChangeListeners::Update::UpdateSystemListener;

use strict;
use SDB::Install::MsgLst;
use SDB::Install::Globals qw($gKeynameEngine $gUpgradeRestrictionsMessage);

sub new {
	return bless bless({}, shift());
}

sub onValueChange {
	my ($self, undef, $configuration) = @_;
	my $mediumComponentManager = $configuration->getMediumComponentManager();
	my $systemComponentManager = $mediumComponentManager->getSystemComponentManager();
	my $sourceServerComponent = $systemComponentManager->getComponentByKeyName($gKeynameEngine);
	my $targetServerComponent = $mediumComponentManager->getComponentByKeyName($gKeynameEngine);

	$configuration->resetError(); # Clean-up any error here. They're going to be ignored anyway

	if(!defined($sourceServerComponent) || !defined($targetServerComponent)){
		$configuration->getErrMsgLst()->addError("Failed to perform upgrade restriction checks");
		return undef;
	}

	my $messageList = new SDB::Install::MsgLst();
	my $errorMessageList = new SDB::Install::MsgLst();
	my $saveContext = $configuration->setMsgLstContext([$messageList, $errorMessageList]);
	my $sourceManifest = $sourceServerComponent->getManifest();
	my $targetManifest = $targetServerComponent->getManifest();
	my $canUpgradeComponent = $configuration->canUpgradeComponent($sourceManifest, $targetManifest, $targetServerComponent->getComponentName(), $messageList);

	$configuration->setMsgLstContext($saveContext);

	if(!$canUpgradeComponent){
		$configuration->getErrMsgLst()->addError($gUpgradeRestrictionsMessage, $errorMessageList);
		return undef;
	}
	return 1;
}

1;