package LCM::Configuration::ValueChangeListeners::Update::XS::OrgNameDetectionListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::Update::XS::BaseUpdateXSDetectionListener';
use SDB::Install::Globals qw ($gKeynameXS2);

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, undef, $instconfig) = @_;

    my $installedXsa = $instconfig->getSystemComponentManager()->getComponentByKeyName($gKeynameXS2);
    return 1 if(!defined $installedXsa);

    if($instconfig->isUpdatingComponent($gKeynameXS2) || ($instconfig->isCockpitOnPlatformAction() && $installedXsa)){
        $self->_updateDefaultValueFromAdminLogin($instconfig) if(!defined $instconfig->getValueOrBatchValue('OrgName'));
        $instconfig->setInteractive('OrgName', 0);
        $instconfig->setHidden('OrgName', 1);
    }
    return 1;
}

sub getConfigParameter{
    return 'OrgName';
}

sub getAdminLoginParameter{
    return 'org-name';
}

1;
