package LCM::Configuration::ValueChangeListeners::Update::XS::XsTenantUserDetectionListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::Update::XS::BaseUpdateXSDetectionListener';
use SDB::Install::Globals qw($gKeynameXS2);

sub new {
    return bless({}, shift());
}
sub getConfigParameter{}
sub getConfigParameters {
    return ['TenantUser', 'SQLTenantUserPassword', 'XSTenantDatabaseName'];
}

sub getAdminLoginParameter{
    return 'runtime-database-name';
}

sub onValueChange {
    my ($self, undef, $instconfig) = @_;
    return 1 if !$instconfig->isUpdatingComponent($gKeynameXS2);
    return $self->enableTenantCredentialsIfNecessary($instconfig);
}

sub enableTenantCredentialsIfNecessary {
    my ($self, $instconfig) = @_;
    my $isConvertRequired = $instconfig->isConvertToMultiDbRequired();
    my $adminLoginParam   = $self->getAdminLoginParameter();
    my $XSRuntimeDBName   = $isConvertRequired ? undef : $instconfig->retrieveXsAdminLoginParam($adminLoginParam);
    my $shouldEnableTenantCredentials = ($isConvertRequired || $XSRuntimeDBName);
    return 1 if !$shouldEnableTenantCredentials;

# The tenant can be either the admin-login value or the SID if convert will be done
    my $tenantName = $isConvertRequired ? $instconfig->getSID() : $XSRuntimeDBName;
    $instconfig->setSkip($_, 0) for @{$self->getConfigParameters()};
    $instconfig->setValue('XSTenantDatabaseName', $tenantName);
    return 1;
}

1;