package LCM::Configuration::ValueChangeListeners::Update::XsTenantDatabaseListener;

use strict;
use base 'LCM::Configuration::ValueChangeListeners::XsTenantDatabaseListener';

sub new {
    return shift->SUPER::new(@_);
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
# If the param does not have a value => XSA goes into SYSTEMDB and the tenant credentials are not needed
# No need to unskip the tenant credentials in the installation config - the selected components listeners handles it
# This listener is added in GenericStackConfiguration because of the action, performed in the parent class
    if (!$configuration->isSystemInCompatibilityMode()) {
        my $shouldSkip = $value ? 0 : 1;
        $configuration->setSkip('TenantUser', $shouldSkip);
        $configuration->setSkip('SQLTenantUserPassword', $shouldSkip);
    }

    return $self->SUPER::onValueChange($value, $configuration);
}

1;
